package root.rdg;

import root.DbContext;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author luk
 */
public class SkillFinder extends BaseFinder<Skill> {

    private static final SkillFinder INSTANCE = new SkillFinder();

    public static SkillFinder getInstance() { return INSTANCE; }

    private SkillFinder() { }

    public Skill findById(int id) throws SQLException {
        return findByInt("SELECT * FROM skills WHERE id = ?", id);
    }

    public List<Skill> findAll() throws SQLException {
        return findAll("SELECT * FROM skills");
    }

    public static List<Skill> classSkills(int classId) throws SQLException {
        List<Skill> skills = new ArrayList<>();
        Connection c = DbContext.getConnection();
        Statement s = c.createStatement();
        ResultSet r = s.executeQuery("SELECT skill_id FROM has_skill WHERE class_id = " + classId);
        while (r.next()) {
            Integer skillId = r.getInt("skill_id");
            Skill skill = SkillFinder.getInstance().findById(skillId);
            skills.add(skill);
        }
        return skills;
    }

    @Override
    protected Skill load(ResultSet r) throws SQLException {
        Skill s = new Skill();
        s.setId(r.getInt("id"));
        s.setName(r.getString("name"));
        s.setDescription(r.getString("description"));
        s.setPowerFactor(r.getDouble("power_factor"));
        s.setHeal(r.getBoolean("is_heal"));
        s.setAttack(r.getBoolean("is_attack"));
        return s;
    }

}
