package root.rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 *
 * @author luk
 */
public class User extends BaseGateway {

    private Integer id;
    private String firstName;
    private String lastLame;
    private String username;
    private String password;
    private int credit;
    private java.sql.Date dateCreated;

    public Integer getId() { return id;	}
    public void setId(Integer id) { this.id = id; }	

    public String getFirstName() { return firstName; }
    public void setFirstName(String firstName) throws FormatException {
        if (firstName.matches(".*\\d+.*"))
            throw new FormatException("First name cannot contain number!");
        this.firstName = firstName;
    }

    public String getLastName() { return lastLame; }
    public void setLastName(String lastName) throws FormatException {
        if (lastName.matches(".*\\d+.*"))
            throw new FormatException("Last name cannot contain number!");
        this.lastLame = lastName;
    }

    public String getUsername() { return username; }
    public void setUsername(String username) throws FormatException {
        if (username.length() >= 13)
            throw new FormatException("Username is too long!");
        else if (username.length() <= 4)
            throw new FormatException("Username is too short!");
        this.username = username;
    }

    public String getPassword() { return password; }
    public void setPassword(String password) throws FormatException {
        if (password.length() >= 8)
            throw new FormatException("Password is too long!");
        else if (password.length() <= 3)
            throw new FormatException("Password is too short!");
        this.password = password;
    }

    public int getCredit() { return credit; }
    public void setCredit(int credit) { this.credit = credit; }

    public java.sql.Date getDateCreated() { return dateCreated;	}
    public void setDateCreated(java.sql.Date dateCreated) { this.dateCreated = dateCreated; }

    public void insert() throws SQLException {
        if (id != null) {
            throw new IllegalStateException("id has been set");
        }

        insert("INSERT INTO users (first_name, last_name, username, password, credit, date_created) VALUES (?,?,?,?,?,?)");
    }

    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setString(1, firstName);
        s.setString(2, lastLame);
        s.setString(3, username);
        s.setString(4, password);
        s.setInt(5, credit);
        s.setDate(6, dateCreated);
    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    public void update() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }

        update("UPDATE users SET first_name = ?, last_name = ?, username = ?, password = ?, credit = ?, date_created = ? WHERE id = ?");
    }

    @Override
    protected void updateFill(PreparedStatement s) throws SQLException {
        insertFill(s);
        s.setInt(7, id);
    }

    public void delete() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }

        delete("DELETE FROM users WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }

}