package root.ui;

import java.util.List;
import root.rdg.JackStatistic;

/**
 *
 * @author shanki
 */
public class JackStatisticsPrinter {
 
    public static void print(List<JackStatistic> statistics) {
        if (statistics == null)
            throw new NullPointerException("statistics cannot be null");

        System.out.print(MainMenu.fillSpace("|month: ", 15));
        System.out.print(MainMenu.fillSpace("|week: ", 15));
        System.out.print(MainMenu.fillSpace("|killer id: ", 15));
        System.out.print(MainMenu.fillSpace("|killer name: ", 15));
        System.out.print(MainMenu.fillSpace("|kills: ", 15));
        System.out.print(MainMenu.fillSpace("|females: ", 15));
        System.out.print(MainMenu.fillSpace("|males: ", 15));
        System.out.println("|");
        MainMenu.printBorder(7, 15);

        for (JackStatistic j : statistics) {
            System.out.print(MainMenu.fillSpace("|" + j.getMonth(), 15));
            if (j.getWeek() == 0) System.out.print(MainMenu.fillSpace("|" + "TOTAL", 15));
            else System.out.print(MainMenu.fillSpace("|" + j.getWeek(), 15));
            System.out.print(MainMenu.fillSpace("|" + j.getCharId(), 15));
            System.out.print(MainMenu.fillSpace("|" + j.getCharName(), 15));
            System.out.print(MainMenu.fillSpace("|" + j.getKills(), 15));
            System.out.print(MainMenu.fillSpace("|" + j.getFemales(), 15));
            System.out.print(MainMenu.fillSpace("|" + j.getMales(), 15));
            System.out.println("|");
        }

    }

}