package root.ui;

import java.util.List;
import root.rdg.JackStatistic;
import root.rdg.OccupancyStatistic;

/**
 *
 * @author shanki
 */
public class OccupancyStatisticsPrinter {
 
    public static void print(List<OccupancyStatistic> statistics) {
        if (statistics == null)
            throw new NullPointerException("statistics cannot be null");

        System.out.print(MainMenu.fillSpace("|week: ", 15));
        System.out.print(MainMenu.fillSpace("|squad: ", 15));
        System.out.print(MainMenu.fillSpace("|players ", 15));
        System.out.print(MainMenu.fillSpace("|kills: ", 15));
        System.out.print(MainMenu.fillSpace("|best_day: ", 15));
        System.out.print(MainMenu.fillSpace("|best_hour: ", 15));

        System.out.println("|");
        MainMenu.printBorder(6, 15);

        for (OccupancyStatistic o : statistics) {
            System.out.print(MainMenu.fillSpace("|" + o.getWeek(), 15));
            System.out.print(MainMenu.fillSpace("|" + o.getSquad(), 15));
            System.out.print(MainMenu.fillSpace("|" + o.getPlayers(), 15));
            System.out.print(MainMenu.fillSpace("|" + o.getTotalKills(), 15));
            System.out.print(MainMenu.fillSpace("|" + o.getBestDay(), 15));
            System.out.print(MainMenu.fillSpace("|" + o.getBestHour(), 15));
            System.out.println("|");
        }

    }

}