package root.ui;

import java.util.List;
import root.rdg.Service;

/**
 *
 * @author luk
 */
public class ServicesPrinter {

    public static void print(List<Service> services) {
        if (services == null)
            throw new NullPointerException("services cannot be null");

        System.out.print(MainMenu.fillSpace("|service id: ", 15));
        System.out.print(MainMenu.fillSpace("|user_id: ", 15));
        System.out.print(MainMenu.fillSpace("|date: ", 15));
        System.out.print(MainMenu.fillSpace("|price: ", 15));
        System.out.print(MainMenu.fillSpace("|type: ", 15));
        System.out.println("|");
        MainMenu.printBorder(5, 15);

        for (Service s : services) {
            System.out.print(MainMenu.fillSpace("|" + s.getId(), 15));
            System.out.print(MainMenu.fillSpace("|" + s.getUserId(), 15));
            System.out.print(MainMenu.fillSpace("|" + s.getKedy(), 15));
            System.out.print(MainMenu.fillSpace("|" + s.getPrice(), 15));
            if (s.getPrice() == 50) System.out.print(MainMenu.fillSpace("|char_transfer", 15));
            else System.out.print(MainMenu.fillSpace("|change_model", 15));
            System.out.println("|");
        }
    }
}