package root.ui;

import root.rdg.Skill;

/**
 *
 * @author luk
 */
public class SkillPrinter {
        
    public static void print(Skill skill) {
        if (skill == null)
            throw new NullPointerException("user cannot be null");

        String id = "|id: " + skill.getId();
        String name = "|name: " + skill.getName();
        String power = "|power_factor: " + skill.getPowerFactor();
        String heal = "|is_heal: " + skill.isHeal();
        String attack = "|is_attack: " + skill.isAttack();
        String desc = "|" + skill.getDescription();

        System.out.print(MainMenu.fillSpace(id, 18));
        System.out.print(MainMenu.fillSpace(name, 18));
        System.out.print(MainMenu.fillSpace(power, 18));
        System.out.print(MainMenu.fillSpace(heal, 18));
        System.out.print(MainMenu.fillSpace(attack, 18));
        System.out.print(MainMenu.fillSpace(desc, 54));

        System.out.println("|");

    }
}
