package root.rdg;

import root.DbContext;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 *
 * @author luk
 */
public class CanBeClass {
    private Integer raceId;
    private Integer classId;

    public Integer getRaceId() {
        return raceId;
    }

    public void setRaceId(Integer raceId) {
        this.raceId = raceId;
    }

    public Integer getClassId() {
        return classId;
    }

    public void setClassId(Integer classId) {
        this.classId = classId;
    }

    public static CanBeClass find(int raceId, int classId) throws SQLException {
        Connection c = DbContext.getConnection();
        PreparedStatement s = c.prepareStatement("SELECT * FROM can_be_class WHERE race_id = ? AND class_id = ?");
        s.setInt(1, raceId);
        s.setInt(2, classId);
        ResultSet r = s.executeQuery();
        if (r.next()) {
            CanBeClass cbc = new CanBeClass();
            cbc.setClassId(r.getInt("race_id"));
            cbc.setClassId(r.getInt("class_id"));
            return cbc;
        } else return null;
    }

    public void insert() throws SQLException {
        Connection c = DbContext.getConnection();
        PreparedStatement s = c.prepareStatement("INSERT INTO can_be_class VALUES (?, ?)");
        s.setInt(1, raceId);
        s.setInt(2, classId);
        s.execute();
    }

}