package root.rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 *
 * @author luk
 */
public class JackStatisticFinder extends BaseFinder<JackStatistic> {

    private static final JackStatisticFinder INSTANCE = new JackStatisticFinder();

    public static JackStatisticFinder getInstance() {
        return INSTANCE;
    }

    private JackStatisticFinder() { }

    public List<JackStatistic> findAll() throws SQLException {
        return findAll("SELECT DISTINCT ON (date_part('month', kedy), date_part('week', kedy))\n" +
                "  date_part('month', kedy) as month,\n" +
                "  date_part('week', kedy) as week,\n" +
                "  killer_id as id,\n" +
                "  c1.name as name,\n" +
                "  count(*) as kills,\n" +
                "  count(females.model_id) as females,\n" +
                "  count(males.model_id) as males\n" +
                "FROM kills\n" +
                "  JOIN characters c1 ON kills.killer_id = c1.id\n" +
                "  LEFT JOIN (characters females JOIN models m1 ON females.model_id = m1.id AND m1.gender = 'F') ON kills.victim_id = females.id\n" +
                "  LEFT JOIN (characters males JOIN models m2 ON males.model_id = m2.id AND m2.gender = 'M') ON kills.victim_id = males.id\n" +
                "GROUP BY GROUPING SETS ( (month, week, killer_id, c1.name), (month, killer_id, c1.name) )\n" +
                "ORDER BY month, week, count(*) DESC;");
    }

    @Override
    protected JackStatistic load(ResultSet r) throws SQLException {
        JackStatistic j = new JackStatistic();

        j.setMonth(r.getInt("month"));
        j.setWeek(r.getInt("week"));
        j.setCharId(r.getInt("id"));
        j.setCharName(r.getString("name"));
        j.setKills(r.getInt("kills"));
        j.setFemales(r.getInt("females"));
        j.setMales(r.getInt("males"));

        return j;
    }

}
