package root.rdg;

import root.DbContext;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 *
 * @author luk
 */
public class KlassaFinder extends BaseFinder<Klassa> {

    private static final KlassaFinder INSTANCE = new KlassaFinder();

    public static KlassaFinder getInstance() { return INSTANCE; }

    private KlassaFinder() { }

    public Klassa findById(int id) throws SQLException {
        return findByInt("SELECT * FROM classes WHERE id = ?", id);
    }

    public List<Klassa> findAll() throws SQLException {
        return findAll("SELECT * FROM classes");
    }

    @Override
    protected Klassa load(ResultSet r) throws SQLException {
        Klassa c = new Klassa();
        c.setId(r.getInt("id"));
        c.setName(r.getString("name"));
        c.setDefaultHp(r.getInt("default_hp"));
        c.setDefaultDef(r.getInt("default_def"));
        c.setDefaultStr(r.getInt("default_str"));
        c.setHpMod(r.getInt("hp_mod"));
        c.setDefMod(r.getInt("def_mod"));
        c.setStrMod(r.getInt("str_mod"));
        return c;
    }

}
