package root.rdg;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import root.DbContext;

/**
 *
 * @author luk
 */
public class StatsFinder extends BaseFinder<Stats> {

    private static final StatsFinder INSTANCE = new StatsFinder();

    public static StatsFinder getInstance() {
        return INSTANCE;
    }

    private StatsFinder() { }

    public Stats findById(int id) throws SQLException {
        return findByInt("SELECT\n" +
                "  ch.id as char_id,\n" +
                "  klassa.default_hp + (klassa.hp_mod * floor(ch.experience / 100)) as max_health,\n" +
                "  klassa.default_def + (klassa.def_mod * floor(ch.experience / 100)) as def,\n" +
                "  klassa.default_str + (klassa.str_mod * floor(ch.experience / 100)) as str\n" +
                "FROM characters ch JOIN classes klassa ON ch.class_id = klassa.id\n" +
                "WHERE ch.id = ?;", id);
    }

    @Override
    protected Stats load(ResultSet r) throws SQLException {
        Stats s = new Stats();
        s.setCharId(r.getInt("char_id"));
        s.setMaxHealth(r.getInt("max_health"));
        s.setDef(r.getInt("def"));
        s.setStr(r.getInt("str"));
        //Načítanie itemov postavy...
        Connection c = DbContext.getConnection();
        PreparedStatement p = c.prepareStatement("SELECT ch.id, i.*\n" +
                "FROM items i JOIN\n" +
                "  has_item hi ON i.id = hi.item_id\n" +
                "  JOIN\n" +
                "  characters ch ON hi.character_id = ch.id\n" +
                "WHERE ch.id = ?");

        p.setInt(1, s.getCharId());
        ResultSet i = p.executeQuery();
        while(i.next()) {
            int newHp = s.getMaxHealth() * (i.getInt("hp_mod") / 10);
            int newDef = s.getDef() * (i.getInt("def_mod") / 10);
            int newStr = s.getStr() * (i.getInt("str_mod") / 10);
            s.setMaxHealth(newHp);
            s.setDef(newDef);
            s.setStr(newStr);
        }
        return s;
    }

}
