package root.ts;

import root.DbContext;
import root.rdg.*;
import root.ui.*;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.*;
import java.time.LocalDateTime;
import java.util.*;

/**
 *
 * @author luk
 */
public class GameActions {

    private static Random rnd = new Random();

    private static final GameActions INSTANCE = new GameActions();

    public static GameActions getInstance() {
        return INSTANCE;
    }

    public void giveItemToChar(int characterId) throws SQLException, IOException, ActionException {
        if (CharakterFinder.getInstance().findById(characterId) == null)
            throw new ActionException("Character with this ID does not exist!");
        System.out.println("Available items:");
        MainMenu.printBorder(5, 17);
        for (Item i : ItemFinder.getInstance().findAll())
            ItemPrinter.print(i);
        MainMenu.printBorder(5, 17);

        System.out.print("Which item? (id): ");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        Integer itemId = Integer.parseInt(br.readLine());

        Item item = ItemFinder.getInstance().findById(itemId);
        if (item == null)
            throw new ActionException("No such item exists!");

        Connection c = DbContext.getConnection();
        PreparedStatement s = c.prepareStatement("INSERT INTO has_item VALUES (?, ?)");
        s.setInt(1, itemId);
        s.setInt(2, characterId);
        s.execute();
        s.close();
    }

    public void doAction(int attackerId, int targetId) throws SQLException, IOException, ActionException {
        Charakter attacker = CharakterFinder.getInstance().findById(attackerId);
        if (attacker == null)
            throw new ActionException("Attacking character does not exist!");;
        Charakter target = CharakterFinder.getInstance().findById(targetId);
        if (target == null)
            throw new ActionException("Target character does not exist!");

        System.out.println("\nAttacker's skills: ");
        MainMenu.printBorder(8, 18);
        for (Skill skill : SkillFinder.classSkills(attacker.getClassId()))
            SkillPrinter.print(skill);
        MainMenu.printBorder(8, 18);

        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("\nWhich skill would you like to use? (id) ");
        Integer skillId = Integer.valueOf(br.readLine());
        Skill attackerSkill = SkillFinder.getInstance().findById(skillId);
        if (attackerSkill == null)
            throw new ActionException("No such skill exists!");
        else if (!SkillFinder.classSkills(attacker.getClassId()).contains(attackerSkill))
            throw new ActionException("Attacking character does not have this skill!");

        System.out.println("\nTarget's health before action: " + target.getHealth());
        useSkill(attacker, target, attackerSkill);

        if (target.getHealth() < 0)
            reviveChar(target);
    }

    public void simulateBattle(int char1Id, int char2Id) throws SQLException, ActionException {
        Charakter character1 = CharakterFinder.getInstance().findById(char1Id);
        if (character1 == null)
            throw new ActionException("Character does not exist!");
        Charakter character2 = CharakterFinder.getInstance().findById(char2Id);
        if (character2 == null)
            throw new ActionException("Character does not exist!");
        List <Skill> char1Skills = SkillFinder.classSkills(character1.getClassId());
        List <Skill> char2Skills = SkillFinder.classSkills(character2.getClassId());
        Skill skill1, skill2;
        System.out.println(Menu.ANSI_BLUE + "--------------BATTLE BEGINS--------------" + Menu.ANSI_RESET);
        while(true) { //While they are alive
            skill1 = char1Skills.get(rnd.nextInt(char1Skills.size()));
            skill2 = char2Skills.get(rnd.nextInt(char2Skills.size()));

            if (rnd.nextInt(2) == 0)
                if (skill1.isAttack())
                    useSkill(character1, character2, skill1);
                else //skill1.isHeal()
                    useSkill(character1, character1, skill1);
            else
                if (skill2.isAttack())
                    useSkill(character2, character1, skill2);
                else //skill2.isHeal()
                    useSkill(character2, character2, skill2);

            if (character1.getHealth() < 0) {
                reviveChar(character1);
                return;
            } else if (character2.getHealth() < 0) {
                reviveChar(character2);
                return;
            }
            System.out.println(Menu.ANSI_BLUE + "-----------------------------------------" + Menu.ANSI_RESET);
            simulateWait(rnd.nextInt(1500) + 500);
        }
    }


    private void useSkill(Charakter charakter1, Charakter charakter2, Skill skill) throws SQLException {
        Stats char1Stats = StatsFinder.getInstance().findById(charakter1.getId());
        Stats char2Stats = StatsFinder.getInstance().findById(charakter2.getId());
        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
        DbContext.getConnection().setAutoCommit(false);

        if (skill.isHeal()) {
            if (charakter1.equals(charakter2))
                System.out.println(charakter1.getName() + " heals himself with " + skill.getName() + "!");
            else
                System.out.println(charakter1.getName() + " heals " + charakter2.getName() + " with " + skill.getName() + "!");

            int amountToHeal = (int) (char1Stats.getStr() * skill.getPowerFactor());
            charakter2.setHealth(charakter2.getHealth() + amountToHeal);
            if (charakter2.getHealth() > char2Stats.getMaxHealth())
                charakter2.setHealth(char2Stats.getMaxHealth());
            System.out.println(charakter2.getName() + " health after heal: " + charakter2.getHealth());

        } else { //attackSkill.isAttack()
            int amountToInflict = (int) (char1Stats.getStr() * skill.getPowerFactor());
            amountToInflict -= char2Stats.getDef();
            System.out.println(charakter1.getName() + " attacks " + charakter2.getName() + " with " + skill.getName() + "!");
            if (amountToInflict < 0) {
                System.out.println(charakter2.getName() + " defense is higher than attack!");
            } else {
                charakter2.setHealth(charakter2.getHealth() - amountToInflict);
                System.out.println(charakter2.getName() + " remaining health: " + charakter2.getHealth());
            }
        }

        if (charakter2.getHealth() < 0) {
            int expAmount = (charakter2.getLevel() - charakter1.getLevel()) * 10;
            if (expAmount < 0) expAmount = 10;
            addExperience(charakter1, expAmount);
            System.out.println(charakter1.getName() + " defeats " +  charakter2.getName() +  " and gets " + expAmount + " experience!");
            logKill(charakter1.getId(), charakter2.getId());
        }

        charakter1.update();
        charakter2.update();
        DbContext.getConnection().commit();
        DbContext.getConnection().setAutoCommit(true);
    }

    private void simulateWait(long amountOfMilis) {
        try {
            Thread.sleep(amountOfMilis);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void rewardBounty(int month) throws SQLException, ActionException {
        int topKillerId = topMonthKiller(month);
        if (topKillerId == 0)
            throw new ActionException("There are no kill statistics for this month!");
        System.out.println(Menu.ANSI_BLUE + "-----------------------------------------" + Menu.ANSI_RESET);
        Set<Integer> avengers = topAvengers(month, topKillerId);
        Charakter c = CharakterFinder.getInstance().findById(topKillerId);
        User u = UserFinder.getInstance().findById(c.getUserId());
        System.out.println(c.getName() + " is the biggest killer of this month,\nhis owner " + u.getUsername() + " gets 30 credits!" );
        rewardUser(u, 30);
        if (avengers.size() == 0)
            System.out.println("There are no avengers!");
        else
            System.out.println("Avengers: ");
        int bounty = 15;
        for (Integer a : avengers) {
            c = CharakterFinder.getInstance().findById(a);
            u = UserFinder.getInstance().findById(c.getUserId());
            System.out.println(u.getUsername() + " gets " + bounty + " credit bounty...");
            rewardUser(u, bounty);
            bounty -= 5;
        }
        System.out.println(Menu.ANSI_BLUE + "-----------------------------------------" + Menu.ANSI_RESET);
    }

    private int topMonthKiller(int month) throws SQLException {
        Connection c = DbContext.getConnection();
        PreparedStatement s = c.prepareStatement("SELECT" +
                "  killer_id FROM kills" +
                "  WHERE date_part('month', kedy) =?" +
                "  GROUP BY killer_id" +
                "  ORDER BY count(*) DESC LIMIT 1;");
        s.setInt(1, month);
        ResultSet r = s.executeQuery();
        if (r.next())
            return r.getInt(1);
        r.close(); s.close();
        return 0;
    }

    private Set<Integer> topAvengers(int month, int charId) throws SQLException {
        Set<Integer> top = new HashSet<>();
        Connection c = DbContext.getConnection();
        PreparedStatement s = c.prepareStatement("SELECT" +
                "  killer_id FROM kills" +
                "  WHERE date_part('month', kedy) = ? AND victim_id = ?" +
                "  GROUP BY killer_id" +
                "  ORDER BY count(*) DESC LIMIT 3;");
        s.setInt(1, month);
        s.setInt(2, charId);
        ResultSet r = s.executeQuery();
        while (r.next())
            top.add(r.getInt(1));
        r.close(); s.close();
        return top;
    }

    private void rewardUser(User user, int amount) throws SQLException {
        user.setCredit(user.getCredit() + amount);
        user.update();
    }

    private void addExperience(Charakter charakter, int amount) throws SQLException {
        try {
            charakter.setExperience(charakter.getExperience() + amount);
        } catch (FormatException e) {
            try { charakter.setExperience(20_000); }
            catch (FormatException e1) { e1.printStackTrace(); }
        }
        charakter.update();
    }

    private void reviveChar(Charakter character) throws SQLException {
        Stats characterStats = StatsFinder.getInstance().findById(character.getId());
        character.setHealth(characterStats.getMaxHealth()); //Respawn with full HP
        character.update();
    }

    private void logKill(int killerId, int victimId) throws SQLException {
        Connection c = DbContext.getConnection();
        PreparedStatement s = c.prepareStatement("INSERT INTO kills VALUES (?, ?, ?)");
        s.setTimestamp(1, Timestamp.valueOf(LocalDateTime.now()));
        s.setInt(2, killerId);
        s.setInt(3, victimId);
        s.execute();
        s.close();
    }

}