CREATE FUNCTION best_day_hour_casual()
  RETURNS TABLE(tyzden double precision, den character varying, hodina integer)
LANGUAGE SQL
AS $$
SELECT DISTINCT ON (date_part('week', kedy))
   date_part('week', kedy) as tyz,
   day_name(EXTRACT(DOW FROM kedy)) as day,
   date_part('hour', kedy)::INTEGER as hour
 FROM kills k JOIN top_players tp on tp.tyzden = date_part('week', kedy) AND tp.ch_id != k.killer_id
 GROUP BY tyz, day, hour
 ORDER BY tyz, count(*) DESC;
$$;

