package root.rdg;

import root.DbContext;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 *
 * @author luk
 */
public class Klassa extends BaseGateway {
	
    private Integer id;
    private String name;
    private Integer defaultHp;
    private Integer defaultStr;
    private Integer defaultDef;
    private Integer hpMod;
    private Integer strMod;
    private Integer defMod;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getDefaultHp() {
        return defaultHp;
    }

    public void setDefaultHp(Integer defaultHp) {
        this.defaultHp = defaultHp;
    }

    public Integer getDefaultStr() {
        return defaultStr;
    }

    public void setDefaultStr(Integer defaultStr) {
        this.defaultStr = defaultStr;
    }

    public Integer getDefaultDef() {
        return defaultDef;
    }

    public void setDefaultDef(Integer defaultDef) {
        this.defaultDef = defaultDef;
    }

    public Integer getHpMod() {
        return hpMod;
    }

    public void setHpMod(Integer hpMod) {
        this.hpMod = hpMod;
    }

    public Integer getStrMod() {
        return strMod;
    }

    public void setStrMod(Integer strMod) {
        this.strMod = strMod;
    }

    public Integer getDefMod() {
        return defMod;
    }

    public void setDefMod(Integer defMod) {
        this.defMod = defMod;
    }

    public void insert() throws SQLException {
        if (id != null) {
            throw new IllegalStateException("id has been set");
        }

        insert("INSERT INTO classes (name, default_hp, default_def, default_str, hp_mod, def_mod, str_mod) VALUES (?,?,?,?,?,?,?)");
    }

    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setString(1, name);
        s.setInt(2, defaultHp);
        s.setInt(3, defaultDef);
        s.setInt(4, defaultStr);
        s.setInt(5, hpMod);
        s.setInt(6, defMod);
        s.setInt(7, strMod);
    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    public void update() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }
        update("UPDATE classes SET name = ?, default_hp = ?, default_def = ?, default_str = ?, hp_mod = ?, def_mod = ?, str_mod = ? WHERE id = ?");
    }

    @Override
    protected void updateFill(PreparedStatement s) throws SQLException {
        insertFill(s);
        s.setInt(8, id);
    }

    public void delete() throws SQLException {
        if (id == null) {
            throw new IllegalStateException("id is not set");
        }
        delete("DELETE FROM classes WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }

    public void insertSkillToClass(int skillId) throws SQLException {
        Connection c = DbContext.getConnection();
        PreparedStatement s = c.prepareStatement("INSERT INTO has_skill VALUES (?, ?)");
        s.setInt(1, skillId);
        s.setInt(2, id);
        s.execute();
    }

    public void deleteSkillFromClass(int skillId) throws SQLException {
        Connection c = DbContext.getConnection();
        PreparedStatement s = c.prepareStatement("DELETE FROM has_skill WHERE skill_id = ? AND class_id = ?");
        s.setInt(1, skillId);
        s.setInt(2, id);
        s.execute();
    }
}