package root.rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 *
 * @author luk
 */
public class RaceFinder extends BaseFinder<Race> {

    private static final RaceFinder INSTANCE = new RaceFinder();

    public static RaceFinder getInstance() { return INSTANCE; }

    private RaceFinder() { }

    public Race findById(int id) throws SQLException {
        return findByInt("SELECT * FROM races WHERE id = ?", id);
    }

    public List<Race> findAll() throws SQLException {
        return findAll("SELECT * FROM races");
    }

    @Override
    protected Race load(ResultSet r) throws SQLException {
        Race a = new Race();

        a.setId(r.getInt("id"));
        a.setName(r.getString("name"));
        a.setSkinColor(r.getString("skin_color"));
        a.setHasHorns(r.getBoolean("has_horns"));
        a.setHasTail(r.getBoolean("has_tail"));
        a.setLore(r.getString("lore"));

        return a;
    }

}
