package root.rdg;

import java.sql.*;

/**
 *
 * @author luk
 */
public class Service extends BaseGateway {

    protected Integer id;
    protected Integer userId;
    protected Date kedy;
    protected Integer price;

    public Integer getId() { return id; }
    public void setId(Integer id) { this.id = id; }

    public Integer getUserId() { return userId; }
    public void setUserId(Integer userId) { this.userId = userId; }

    public Date getKedy() { return kedy; }
    public void setKedy(Date kedy) { this.kedy = kedy; }

    public Integer getPrice() {
        return price;
    }

    public void setPrice(Integer price) {
        this.price = price;
    }

    public void insert() throws SQLException {
        insert("INSERT INTO services (kedy, user_id, price) VALUES (?,?,?)");
    }

    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setDate(1, kedy);
        s.setInt(2, userId);
        s.setInt(3, price);
    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    public void update() throws SQLException {
        update("UPDATE services SET kedy = ?, user_id = ?, price = ? WHERE id = ?");
    }

    @Override
    protected void updateFill(PreparedStatement s) throws SQLException {
        s.setDate(1, kedy);
        s.setInt(2, userId);
        s.setInt(3, price);
        s.setInt(4, id);
    }

    public void delete() throws SQLException {
        delete("DELETE FROM services WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }

}
