/**
 * Author: luk
 * Created: Apr 06, 2018
 */

drop table if exists items cascade;
create table items
(
    id serial primary key,
    name varchar,
    hp_mod integer,
    def_mod integer,
    str_mod integer
);

drop table if exists users cascade;
create table users
(
    id serial primary key,
    first_name varchar,
    last_name varchar,
    username varchar unique check(length(username) < 13 AND length(username) > 4),
    password varchar check(length(password) > 3 AND length(password) < 8),
    credit integer,
    date_created date
);

drop table if exists services cascade;
create table services
(
    id serial primary key,
    kedy date,
    price integer,
    user_id integer references users,
    service_type varchar, -- change_model, char_transfer
    character_id integer -- references characters (alter)
);

drop table if exists skills cascade;
create table skills
(
    id serial primary key,
    name varchar,
    description varchar,
    power_factor float,
    is_heal boolean,
    is_attack boolean
);

drop table if exists classes cascade;
create table classes
(
    id serial primary key,
    name varchar,
    default_hp integer,
    default_def integer,
    default_str integer,
    hp_mod integer,
    def_mod integer,
    str_mod integer
);

drop table if exists races cascade;
create table races
(
    id serial primary key,
    name varchar,
    lore varchar,
    skin_color varchar,
    has_horns boolean,
    has_tail boolean
);

drop table if exists has_skill cascade;
create table has_skill
(
    skill_id integer references skills,
    class_id integer references classes
);

drop table if exists can_be_class cascade;
create table can_be_class
(
    race_id integer references races,
    class_id integer references classes
);

drop table if exists models cascade;
create table models
(
    id serial primary key,
    gender varchar CHECK (gender = 'M' or gender = 'F'),
    height integer,
    weight integer,
    hair_color varchar,
    eye_color varchar
);

drop table if exists characters cascade;
create table characters
(
    id serial primary key,
    name varchar check(length(name) < 8 AND length(name) > 3),
    experience integer check(experience <= 20000 AND experience >= 0),
    race_id integer references races,
    class_id integer references classes,
    user_id integer references users,
    model_id integer references models,
    health integer
);

drop table if exists has_item cascade;
create table has_item
(
    item_id integer references items,
    character_id integer references characters
);

drop table if exists kills cascade;
create table kills
(
    kedy TIMESTAMP,
    killer_id integer references characters,
    victim_id integer references characters
);

ALTER TABLE services ADD
    FOREIGN KEY (character_id)
    REFERENCES characters(id);
