/**
* Author: luk
* Created: Apr 06, 2018
 */

-- Najprv zmazeme vsetky data. Mohli by sme to robit rucne cez DELETE po jednej tabulke.
-- Museli by sme ale brat do uvahy zavislosti medzi tabulkami. Takto to za nas spravi TRUNCATE.

truncate table users, services, models, characters, items, has_item, races, classes, skills, can_be_class, has_skill, kills restart identity cascade;

---- pomocne tabulky na generovanie dat

-- first names

drop table if exists first_names cascade;
create table first_names
(
    first_name varchar
);

insert into first_names (first_name)
values	('James'), ('Willie'), ('Chad'), ('Zachary'), ('Mathew'),
	('John'), ('Ralph'), ('Jacob'), ('Corey'), ('Tyrone'),
	('Robert'), ('Lawrence'), ('Lee'), ('Herman'), ('Darren'),
	('Michael'), ('Nicholas'), ('Melvin'), ('Maurice'), ('Lonnie'),
	('William'), ('Roy'), ('Alfred'), ('Vernon'), ('Lance'),
	('David'), ('Benjamin'), ('Kyle'), ('Roberto'), ('Cody');

-- last names

drop table if exists last_names cascade;
create table last_names
(
    last_name varchar
);

insert into last_names (last_name)
values	('Smith'), ('Jones'), ('Taylor'), ('Williams'), ('Brown'),
	('Davies'), ('Evans'), ('Wilson'), ('Thomas'), ('Roberts'),
	('Johnson'), ('Lewis'), ('Walker'), ('Robinson'), ('Wood'),
	('Thompson'), ('White'), ('Watson'), ('Jackson'), ('Wright'),
	('Green'), ('Harris'), ('Cooper'), ('King'), ('Lee'),
	('Martin'), ('Clarke'), ('James'), ('Morgan'), ('Hughes'),
	('Edwards'), ('Hill'), ('Moore'), ('Clark'), ('Harrison'),
	('Scott'), ('Young'), ('Morris'), ('Hall'), ('Ward'),
	('Turner'), ('Carter'), ('Phillips'), ('Mitchell'), ('Patel'),
	('Adams'), ('Campbell'), ('Anderson'), ('Allen'), ('Cook');

---- hlavne tabulky

-- users

create or replace function random_first_name() returns varchar language sql as
$$
select first_name from first_names tablesample system_rows(10) order by random() limit 1
$$;

create or replace function random_last_name() returns varchar language sql as
$$
select last_name from last_names tablesample system_rows(10) order by random() limit 1
$$;

create or replace function random_pass() returns varchar language sql as
$$
SELECT array_to_string(ARRAY(SELECT chr((33 + floor(random() * 90))::integer)
														 FROM generate_series(1,7)), '')
$$;

insert into users (first_name, last_name, username, password, credit, date_created)
select	random_first_name(),
        random_last_name(),
        'user' || i as username,
			  random_pass() as password,
        floor(random() * 100) as credit,
        date '2017-01-01' + floor(random()*350)::integer as date_created
from generate_series(1, 10000) as seq(i);

-- models

insert into models (gender, height, weight, hair_color, eye_color)
  select  CASE floor(random() * 2)
            WHEN 0 THEN 'M'
            ELSE 'F'
          END AS gender,
          floor(random() * 60) + 150 as height,
          floor(random() * 30) + 60 as weight,
          CASE floor(random() * 3)
            WHEN 0 THEN 'Brown'
            WHEN 1 THEN 'Blonde'
            ELSE 'Black'
          END AS hair_color,
          CASE floor(random() * 3)
            WHEN 0 THEN 'Brown'
            WHEN 1 THEN 'Blue'
          ELSE 'Green'
          END AS eye_color
  from generate_series(1, 20) as seq(i);

-- races

insert into races (name, lore, skin_color, has_horns, has_tail)
	VALUES ('Humans', 'Humans are friendly at first, but envy easily turn them into monsters.', 'white', FALSE, FALSE),
				 ('Orcs', 'Orcs live in tribes. They are very unforgiving if someone touches their land.', 'green', TRUE, FALSE),
				 ('Taurens', 'Taurens praises the nature and are very strong. Ground shakes beneath them.', 'brown', TRUE, TRUE),
				 ('Dwarves', 'Even though small to look at, a dwarf can be a mighty enemy.', 'gray', FALSE, FALSE);

-- classes

insert into classes (name, default_hp, default_def, default_str, hp_mod, def_mod, str_mod)
VALUES ('Warrior', 120, 30, 25, 15, 17, 12),
			 ('Hunter', 90, 20, 40, 13, 15, 17),
	     ('Priest', 100, 25, 15, 14, 18, 14);

-- skills

insert into skills (name, description, power_factor, is_heal, is_attack)
VALUES ('Slash', 'Slash a foe with a powerful strike.', 1.4, FALSE, TRUE),
	     ('Shot', 'Hunter uses his bow for a steady Shot.', 1.9, FALSE, TRUE),
			 ('Heal', 'Priest makes a holy prayer, healing his allies.', 1, TRUE, FALSE),
       ('Charge', 'Warrior Charges forward with his huge shield.', 1.6, FALSE, TRUE),
       ('Backstab', 'Using his agility, hunter gets behind enemy and Stab him.', 2.2, FALSE, TRUE),
       ('Smite', 'Gods can also be very cruel and Smite all non-believers.', 1.5, FALSE, TRUE),
       ('Block', 'Warrior uses his shield to reflect damage.', 1, FALSE, TRUE),
       ('Throw', 'Hunter throws a hidden dagger.', 1.5, FALSE, TRUE),
       ('Enlight', 'Enlightning his enemy, priest deals luminary damage.', 1.4, FALSE, TRUE);

-- has_skill

insert into has_skill(skill_id, class_id)
VALUES (1, 1),
	     (2, 2),
	     (3, 3),
       (4, 1),
       (5, 2),
       (6, 3),
       (7, 1),
       (8, 2),
       (9, 3);

-- characters

create or replace function random_user(dummy_in integer) returns table (id integer) language sql as
$$
select id from users tablesample system_rows(10) ORDER BY random() LIMIT 1
$$;

create or replace function random_model(dummy_in integer) returns table (id integer) language sql as
$$
select id from models tablesample system_rows(10) ORDER BY random() LIMIT 1
$$;

create or replace function random_race(dummy_in integer) returns table (id integer) language sql as
$$
select id from races tablesample system_rows(10) ORDER BY random() LIMIT 1
$$;

create or replace function random_class(dummy_in integer) returns table (id integer) language sql as
$$
select id from classes tablesample system_rows(10) ORDER BY random() LIMIT 1
$$;

insert into characters  (name, experience, race_id, class_id, user_id, model_id, health)
	select
		'char' || floor(random() * 200) + 10 as name,
    floor(random() * 2000),
		races.id as race_id,
		NULL as class_id,
		users.id,
		models.id model_id,
		NULL as health
	from generate_series(1,10000) as seq(i),
		lateral random_user(i) as users,
    lateral random_model(i) as models,
    lateral random_race(i) as races,
    lateral random_class(i) as classes; -- prenasame id, aby sme zakazdnym mali nove volanie

-- can_be_class

insert into can_be_class(race_id, class_id)
    VALUES (1, 1),
           (1, 3),
           (2, 1),
           (2, 2),
           (3, 2),
           (3, 3),
           (4, 1),
           (4, 3);

update characters
  set class_id = (SELECT class_id
                    from can_be_class
                    WHERE characters.race_id = can_be_class.race_id
                  ORDER BY random() LIMIT 1);

update characters
  set health = floor(random() * (SELECT
                            classes.default_hp + (classes.hp_mod * floor(characters.experience / 100)) --experience / 100 vypočíta level...
                            FROM classes where classes.id = characters.class_id)) + 1;

-- kills

create or replace function random_char(dummy_in integer) returns table (id integer) language sql as
$$
select id from characters tablesample system_rows(10) ORDER BY random() LIMIT 1
$$;

create or replace function random_timestamp(dummy_in integer) returns TIMESTAMP language sql as
$$
  SELECT
    (DATE '2018-01-01' + floor(random()*100)::integer)::TIMESTAMP
    + floor(random() * 24 ) * INTERVAL '1 hour' as timestamp;
$$;

insert into kills (kedy, killer_id, victim_id)
		SELECT
      random_timestamp(i) as kedy,
			char1.id as killer_id,
			char2.id as victim_id
		from generate_series(1, 10000) as seq(i),
			lateral random_char(i) as char1, lateral random_char(i) as char2;

-- items

insert into items(name, hp_mod, def_mod, str_mod)
  select
    'item' || i as name,
    floor(random() * 10) + 10 as hp_mod,
    floor(random() * 10) + 10 as def_mod,
    floor(random() * 10) + 10 as str_mod
  from generate_series(1,100) as seq(i);

-- has_item

create or replace function random_item(dummy_in integer) returns table (id integer) language sql as
$$
select id from items tablesample system_rows(10) ORDER BY random() LIMIT 1
$$;

insert into has_item(item_id, character_id)
  select
    item.id as item_id,
    ch.id as character_id
  from generate_series(1, 1000) as seq(i),
    lateral random_char(i) as ch, lateral random_item(i) as item;

-- services

insert into services (kedy, price, user_id, service_type, character_id)
	SELECT
			date '2018-01-01' + floor(random()*100)::integer as kedy,
			CASE floor(random() * 2)
				WHEN 0 THEN 50
				ELSE 30
			END AS price,
			u.id as user_id,
			NULL as service_type,
			ch.id as char1_id
	from generate_series(1, 1000) as seq(i),
			lateral random_char(i) as ch, lateral random_user(i) as u;

update services
  set service_type = (CASE (price)
                        WHEN 30 THEN 'change_model'
                        ELSE 'char_transfer'
                      END);

--- Delete helper functions

drop table first_names, last_names cascade;

drop function random_first_name();
drop function random_last_name();
drop function random_pass();
drop function random_user(integer);
drop function random_char(integer);
drop function random_model(integer);
drop function random_race(integer);
drop function random_class(integer);
drop function random_item(integer);
drop function random_timestamp(integer);

--- Indexy ---

DROP INDEX IF EXISTS username_index;
CREATE INDEX username_index ON users(username);

DROP INDEX IF EXISTS name_index;
CREATE INDEX name_index ON characters(name);

DROP INDEX IF EXISTS service_user;
CREATE INDEX service_user on services(user_id);

DROP INDEX IF EXISTS tyzden;
CREATE INDEX tyzden on kills(date_part('week', kedy));
CLUSTER kills USING tyzden;

--- Functions ---

DROP FUNCTION IF EXISTS day_name(DOUBLE PRECISION);
DROP FUNCTION IF EXISTS percentile_for_week(DOUBLE PRECISION) CASCADE;
DROP FUNCTION IF EXISTS player_kills() CASCADE;
DROP FUNCTION IF EXISTS best_day_hour() CASCADE;
DROP FUNCTION IF EXISTS best_day_hour_casual() CASCADE;

CREATE OR REPLACE FUNCTION day_name(day DOUBLE PRECISION) RETURNS VARCHAR(10) language sql as
$$
SELECT
  CASE(day)
  WHEN 0 THEN 'Sunday'
  WHEN 1 THEN 'Monday'
  WHEN 2 THEN 'Tuesday'
  WHEN 3 THEN 'Wednesday'
  WHEN 4 THEN 'Thursday'
  WHEN 5 THEN 'Friday'
  WHEN 6 THEN 'Saturday'
  END as day_name;
$$;

create or replace function player_kills() returns TABLE(tyzden int, p_id int, kills int) language sql as
$$
SELECT
  date_part('week', kedy)::INTEGER as tyzden,
  c.user_id as p_id,
  count(*)::INTEGER as kills
FROM kills JOIN characters c ON kills.killer_id = c.id JOIN users u ON c.user_id = u.id
GROUP BY tyzden, p_id
$$;

----------------------------------------
-- |tyzden:   |p_id:      |kills       |
-- |1         |123        |15          |
-- |...       |...        |...         |
----------------------------------------

create or replace function percentile_for_week(tyz DOUBLE PRECISION) returns integer language sql as
$$
SELECT
  percentile_disc(0.9) WITHIN GROUP (ORDER BY kills)::INTEGER
FROM
  (SELECT
  c.user_id as p_id,
  count(*)::INTEGER as kills
  FROM kills JOIN characters c ON kills.killer_id = c.id JOIN users u ON c.user_id = u.id
  WHERE date_part('week', kedy) = tyz
  GROUP BY p_id) as pk;
$$;

--- MATERIALIZED VIEW TOP-PLAYERS

DROP VIEW IF EXISTS top_players;
DROP MATERIALIZED VIEW IF EXISTS top_players;

CREATE MATERIALIZED VIEW top_players AS
  SELECT tyzden, p_id
  FROM player_kills()
  WHERE kills >= percentile_for_week(tyzden);

---

create or replace function best_day_hour_pros() returns TABLE(tyzden DOUBLE PRECISION, den VARCHAR, hodina int) language sql as
$$
SELECT DISTINCT ON (date_part('week', k.kedy))
  date_part('week', k.kedy) as tyz,
  day_name(EXTRACT(DOW FROM k.kedy)) as day,
  date_part('hour', k.kedy)::INTEGER as hour
FROM
  (kills k JOIN characters c ON k.killer_id = c.id)
  JOIN top_players tp ON tp.tyzden = date_part('week', k.kedy) AND c.user_id = tp.p_id
GROUP BY tyz, day, hour
ORDER BY tyz, count(*) DESC;
$$;

create or replace function best_day_hour_casuals() returns TABLE(tyzden DOUBLE PRECISION, den VARCHAR, hodina int) language sql as
$$
SELECT DISTINCT ON (date_part('week', k.kedy))
  date_part('week', k.kedy) as tyz,
  day_name(EXTRACT(DOW FROM k.kedy)) as day,
  date_part('hour', k.kedy)::INTEGER as hour
FROM
  (kills k JOIN characters c ON k.killer_id = c.id)
  JOIN top_players tp ON tp.tyzden = date_part('week', k.kedy) AND c.user_id != tp.p_id
GROUP BY tyz, day, hour
ORDER BY tyz, count(*) DESC;
$$;

