package root.ts;

import root.DbContext;
import root.rdg.*;
import root.ui.MenuException;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;

public class OtherActions {

    public static void addClassToRace(Klassa klassa, Race race) throws SQLException {
        CanBeClass cbc = new CanBeClass();
        cbc.setClassId(klassa.getId());
        cbc.setRaceId(race.getId());
        cbc.insert();
    }

    public static void addSkillToClass(Skill skill, Klassa klassa) throws SQLException, MenuException {
        if (SkillFinder.classSkills(klassa.getId()).contains(skill)) {
            throw new MenuException("This class already has this skill!");
        }
        else {
            klassa.insertSkillToClass(skill.getId());
        }
    }

    public static void deleteSkillFromClass(Skill skill, Klassa klassa) throws MenuException, SQLException {
        if (SkillFinder.classSkills(klassa.getId()).contains(skill) == false) {
            throw new MenuException("This class does not have this skill!");
        } else {
            klassa.deleteSkillFromClass(skill.getId());
        }
    }

    public static Set<Integer> classesForRace(int raceId) throws SQLException {
        Set<Integer> classes = new HashSet<>();
        Connection c = DbContext.getConnection();
        Statement s = c.createStatement();
        ResultSet r = s.executeQuery("SELECT class_id FROM can_be_class WHERE can_be_class.race_id = " + raceId);
        while (r.next())
            classes.add(r.getInt(1));
        r.close(); s.close();
        return classes;
    }

}
