package root.ts;

import root.DbContext;
import root.rdg.*;
import root.rdg.Charakter;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.time.LocalDate;

/**
 *
 * @author luk
 */
public class PlayerServices {

    private static final PlayerServices INSTANCE = new PlayerServices();
    
    public static PlayerServices getInstance() {
        return INSTANCE;
    }

    public boolean transferChar(User destUser, User sourceUser,  Charakter charakter) throws SQLException, ServiceException, FormatException {
        if (charakter == null) throw new ServiceException("charakter is null");
        if (charakter.getUserId() != sourceUser.getId()) {
            throw new ServiceException("This character does not belong to the source user!");
        }

        Connection c = DbContext.getConnection();
        c.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);
        c.setAutoCommit(false);

        try {
            CharTransfer transfer = new CharTransfer();

            transfer.setUserId(destUser.getId());
            transfer.setCharacterId(charakter.getId());
            transfer.setKedy(Date.valueOf(LocalDate.now()));
            transfer.insert();

            chargeUser(destUser, 50); //10 credit fee
            sourceUser.setCredit(sourceUser.getCredit() + 40);
            sourceUser.update();

            charakter.setUserId(destUser.getId());
            charakter.update();

            c.commit();

            return true;
        } catch (Exception e) {
            c.rollback();
            throw e;
        } finally {
            c.setAutoCommit(true);
        }
    }

    public void changeAppearance(int characterId, int modelId, User user) throws ServiceException, SQLException {
        Charakter ch = CharakterFinder.getInstance().findById(characterId);
        if (ch == null) throw new ServiceException("Character does not exist!");
        if (ch.getUserId() != user.getId()) {
            throw new ServiceException("This character does not belong to this user!");
        }

        Connection c = DbContext.getConnection();
        c.setTransactionIsolation(Connection.TRANSACTION_READ_COMMITTED);
        c.setAutoCommit(false);

        try {
            ChangeModel change = new ChangeModel();
            change.setUserId(user.getId());
            change.setCharacterId(characterId);
            change.setKedy(Date.valueOf(LocalDate.now()));
            change.insert();

            chargeUser(user, 30);

            ch.setModelId(modelId);
            ch.update();

            c.commit();
        } catch (Exception e) {
            c.rollback();
            throw e;
        } finally {
            c.setAutoCommit(true);
        }
    }

    private void chargeUser(User user, int amount) throws ServiceException, SQLException {
        if (user.getCredit() - amount < 0) {
            throw new ServiceException("User has insufficient credits for this service!");
        }
        user.setCredit(user.getCredit() - amount);
        user.update();
    }

}