package root.ui;

import root.rdg.Stats;

/**
 *
 * @author luk
 */
public class StatsPrinter {

    public static void print(Stats s) {
        if (s == null)
            throw new NullPointerException("stats cannot be null");

        String id = "|char_id: " + s.getCharId();
        String health = "|max_hp: " + s.getMaxHealth();
        String def = "|def: " + s.getDef();
        String str = "|str: " + s.getStr();

        MainMenu.printBorder(4, 15);
        System.out.print(MainMenu.fillSpace(id, 15));
        System.out.print(MainMenu.fillSpace(health, 15));
        System.out.print(MainMenu.fillSpace(def, 15));
        System.out.print(MainMenu.fillSpace(str, 15));
        System.out.println("|");
        MainMenu.printBorder(4, 15);
    }
}