CREATE FUNCTION percentile_for_week(tyz double precision)
  RETURNS integer
LANGUAGE SQL
AS $$
SELECT
   percentile_disc(0.9) WITHIN GROUP (ORDER BY kills)::INTEGER
 FROM
   (SELECT
      date_part('week', kedy) as week,
      killer_id as ch_id,
      count(*) as kills
    FROM kills
    WHERE date_part('week', kedy) = tyz
    GROUP BY week, ch_id
   ) as kills;
$$;

