package root;

import java.sql.Connection;
import java.sql.SQLException;

/**
 *
 * @author shanki
 */
public class DbContext {

    private static Connection connection;

    private DbContext () { };

    public static void setConnection(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }

        DbContext.connection = connection;
    }

    public static Connection getConnection() {
        if (connection == null) {
            throw new IllegalStateException("connection must be set before calling this method");
        }

        return connection;
    }

    public static void clear() throws SQLException{
        connection.close();
        connection = null;
    }

}
