package root.rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 *
 * @author luk
 */
public class ModelFinder extends BaseFinder<Model> {

    private static final ModelFinder INSTANCE = new ModelFinder();

    public static ModelFinder getInstance() { return INSTANCE; }

    private ModelFinder() { }

    public Model findById(int id) throws SQLException {
        return findByInt("SELECT * FROM models WHERE id = ?", id);
    }

    public List<Model> findAll() throws SQLException {
        return findAll("SELECT * FROM models");
    }

    @Override
    protected Model load(ResultSet r) throws SQLException {
        Model m = new Model();
        m.setId(r.getInt("id"));
        m.setGender(r.getString("gender"));
        m.setHeight(r.getInt("height"));
        m.setWeight(r.getInt("weight"));
        m.setHairColor(r.getString("hair_color"));
        m.setEyeColor(r.getString("eye_color"));
        return m;
    }

}
