package root.rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 *
 * @author luk
 */
public class UserFinder extends BaseFinder<User> {

    private static final UserFinder INSTANCE = new UserFinder();

    public static UserFinder getInstance() { return INSTANCE; }

    private UserFinder() { }

    public User findById(int id) throws SQLException {
        return findByInt("SELECT * FROM users WHERE id = ?", id);
    }

    public User findByUsername(String username) throws SQLException {
        return findByStr("SELECT * FROM users WHERE username = ?", username);
    }

    public List<User> findAll() throws SQLException {
        return findAll("SELECT * FROM users");
    }

    public List<User> findAllPage(int pageSize, int pageCount) throws SQLException {
        return findAll("SELECT * FROM users " + "OFFSET " + pageCount * pageSize  + "LIMIT " + pageSize);
    }

    @Override
    protected User load(ResultSet r) throws SQLException {
        User u = new User();

        try {
            u.setId(r.getInt("id"));
            u.setFirstName(r.getString("first_name"));
            u.setLastName(r.getString("last_name"));
            u.setUsername(r.getString("username"));
            u.setPassword(r.getString("password"));
            u.setCredit(r.getInt("credit"));
            u.setDateCreated(r.getDate("date_created"));
        } catch (FormatException e) { e.printStackTrace(); }

        return u;
    }

}
