package root.ui;

import root.rdg.Model;
import root.rdg.Service;

import java.util.List;

/**
 *
 * @author shanki
 */
public class ModelPrinter {
        
    public static void print(List<Model> models) {
        if (models == null)
            throw new NullPointerException("models cannot be null");

        System.out.print(MainMenu.fillSpace("|model_id: ", 15));
        System.out.print(MainMenu.fillSpace("|gender: ", 15));
        System.out.print(MainMenu.fillSpace("|height: ", 15));
        System.out.print(MainMenu.fillSpace("|weight: ", 15));
        System.out.print(MainMenu.fillSpace("|hair_color: ", 15));
        System.out.print(MainMenu.fillSpace("|eye_color: ", 15));
        System.out.println("|");
        MainMenu.printBorder(6, 15);
        for (Model m : models) {
            System.out.print(MainMenu.fillSpace("|" + m.getId(), 15));
            System.out.print(MainMenu.fillSpace("|" + m.getGender(), 15));
            System.out.print(MainMenu.fillSpace("|" + m.getHeight(), 15));
            System.out.print(MainMenu.fillSpace("|" + m.getWeight(), 15));
            System.out.print(MainMenu.fillSpace("|" + m.getHairColor(), 15));
            System.out.print(MainMenu.fillSpace("|" + m.getEyeColor(), 15));
            System.out.println("|");
        }
        MainMenu.printBorder(6, 15);
    }

}
