package root.rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import root.DbContext;

@SuppressWarnings("Duplicates")

/**
 *
 * @author shanki
 */
public abstract class BaseFinder<T> {

    protected List<T> findAll(String query) throws SQLException {
        if (query == null) {
            throw new NullPointerException("query cannot be null");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement(query)) {
            try (ResultSet r = s.executeQuery()) {

                List<T> elements = new ArrayList<>();

                while (r.next()) {
                    elements.add(load(r));
                }

                return elements;
            }
        }
    }

    protected T findByInt(String query, int value) throws SQLException {
        if (query == null) {
            throw new NullPointerException("query cannot be null");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement(query)) {
            s.setInt(1, value);

            try (ResultSet r = s.executeQuery()) {
                if (r.next()) {
                    T c = load(r);

                    if (r.next()) {
                        throw new RuntimeException("More than one row was returned");
                    }

                    return c;
                } else {
                    return null;
                }

            }
        }
    }

    protected T findByStr(String query, String value) throws SQLException {
        if (query == null) {
            throw new NullPointerException("query cannot be null");
        }

        try (PreparedStatement s = DbContext.getConnection().prepareStatement(query)) {
            s.setString(1, value);

            try (ResultSet r = s.executeQuery()) {
                if (r.next()) {
                    T c = load(r);

                    if (r.next()) {
                        throw new RuntimeException("More than one row was returned");
                    }

                    return c;
                } else {
                    return null;
                }

            }
        }
    }

    protected abstract T load(ResultSet r) throws SQLException;

}
