package root.rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;

/**
 *
 * @author luk
 */
public class Charakter extends BaseGateway {
	
    private Integer id;
    private String name;
    private Integer level;
    private Integer experience;
    private Integer raceId;
    private Integer classId;
    private Integer userId;
    private Integer modelId;
    private Integer health;
    private String className;

    public Charakter() {
        level = 0;
        experience = 0;
    }

    public String getClassName() {
        return className;
    }
    public void setClassName(String className) {
        this.className = className;
    }

    public Integer getId() { return id;	}
    public void setId(Integer id) { this.id = id; }	

    public String getName() { return name; }
    public void setName(String name) throws FormatException {
        if (name.length() >= 8)
            throw new FormatException("Name is too long!");
        else if (name.length() <= 3)
            throw new FormatException("Name is too short!");
        this.name = name;
    }

    public Integer getLevel() { return level;	}
    public void setLevel(Integer level) { this.level = level; }

    public Integer getExperience() { return experience;	}
    public void setExperience(Integer experience) throws FormatException {
        if (experience > 20_000)
            throw new FormatException("Experience cannot exceed maximum!");
        else if (experience < 0)
            throw new FormatException("Experience cannot be negative!");
        this.experience = experience;
    }

    public Integer getRaceId() { return raceId;	}
    public void setRaceId(Integer raceId) throws SQLException, FormatException {
        if (raceId < 1 || raceId > RaceFinder.getInstance().findAll().size())
            throw new FormatException("Race does not exist!");
        this.raceId = raceId;
    }

    public Integer getClassId() { return classId;	}
    public void setClassId(Integer classId) throws SQLException, FormatException {
        if (classId < 1 || classId > KlassaFinder.getInstance().findAll().size())
            throw new FormatException("Class does not exist!");
        this.classId = classId;
    }

    public Integer getUserId() { return userId;	}
    public void setUserId(Integer userId) throws FormatException {
        if (userId < 0)
            throw new FormatException("Invalid user id!");
        this.userId = userId;
    }

    public Integer getModelId() { return modelId;	}
    public void setModelId(Integer modelId) {
        this.modelId = modelId;
    }

    public Integer getHealth() { return health;	}
    public void setHealth(Integer health) { this.health = health; }


    public void insert() throws SQLException {
        if (id != null) {
            throw new IllegalStateException("id has been set");
        }

        insert("INSERT INTO characters (name, experience, race_id, class_id, user_id, model_id, health) VALUES (?,?,?,?,?,?,?)");
    }

    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setString(1, name);
        s.setInt(2, experience);

        if (raceId == null || raceId == 0) s.setNull(3, java.sql.Types.INTEGER);
        else s.setInt(3, raceId);

        if (classId == null || classId == 0) s.setNull(4, java.sql.Types.INTEGER);
        else s.setInt(4, classId);

        if (userId == null || userId == 0) s.setNull(5, java.sql.Types.INTEGER);
        else s.setInt(5, userId);

        if (modelId == null || modelId == 0) s.setNull(6, java.sql.Types.INTEGER);
        else s.setInt(6, modelId);

        s.setInt(7, health);
    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    public void update() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }
        update("UPDATE characters SET name = ?, experience = ?, race_id = ?, class_id = ?, user_id = ?, model_id = ?, health = ? WHERE id = ?");
    }

    @Override
    protected void updateFill(PreparedStatement s) throws SQLException {
        insertFill(s);
        s.setInt(8, id);
    }

    public void delete() throws SQLException {
        if (id == null) {
                throw new IllegalStateException("id is not set");
        }
        delete("DELETE FROM characters WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Charakter charakter = (Charakter) o;
        return charakter.getId().equals(id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, name);
    }
}