package root.rdg;

import root.DbContext;
import root.Main;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

/**
 *
 * @author luk
 */
public class CharakterFinder extends BaseFinder<Charakter> {

    private static final CharakterFinder INSTANCE = new CharakterFinder();

    public static CharakterFinder getInstance() { return INSTANCE; }

    private CharakterFinder() { }

    public Charakter findById(int id) throws SQLException {
        return findByInt("SELECT * FROM characters WHERE id = ?", id);
    }

    public Charakter findByName(String name) throws SQLException {
        return findByStr("SELECT * FROM characters WHERE name = ?", name);
    }

    public List<Charakter> findByOwnerId(int ownerId) throws SQLException {
        return findAll("SELECT * FROM characters WHERE user_id = " + String.valueOf(ownerId));
    }

    public List<Charakter> findAll() throws SQLException {
        return findAll("SELECT * FROM characters");
    }

    public List<Charakter> findAllPage(int pageSize, int pageCount) throws SQLException {
        return findAll("SELECT * FROM characters " + "OFFSET " + pageCount * pageSize  + "LIMIT " + pageSize);
    }

    @Override
    protected Charakter load(ResultSet r) throws SQLException {
        Charakter c = new Charakter();

        try {
            c.setId(r.getInt("id"));
            c.setName(r.getString("name"));
            c.setLevel(r.getInt("experience") / 100);
            c.setExperience(r.getInt("experience"));
            c.setRaceId(r.getInt("race_id"));
            c.setClassId(r.getInt("class_id"));
            c.setUserId(r.getInt("user_id"));
            c.setModelId(r.getInt("model_id"));
            c.setHealth(r.getInt("health"));

            //OPTIMÁLNE
            c.setClassName(Main.classNames.get(c.getClassId()));
            //NEOPTIMÁLNE
            //c.setClassName(className(c.getClassId()));

        } catch (FormatException e) {
            e.printStackTrace();
        }

        return c;
    }

    private static String className(int classId) {
        try {
            Connection c = DbContext.getConnection();
            Statement s = c.createStatement();
            ResultSet r = s.executeQuery("SELECT name from classes WHERE id = " + classId);
            if (r.next())
                return r.getString(1);
        } catch (SQLException e) { e.printStackTrace(); }
        return null;
    }
}
