package root.ui;

import root.rdg.Charakter;

/**
 *
 * @author shanki
 */
public class CharacterPrinter {

    public static void print(Charakter charakter) {
        if (charakter == null)
            throw new NullPointerException("charakter cannot be null");

        String id = "|id: " + charakter.getId();
        String name = "|name: " + charakter.getName();
        String ownerId = "|owner: " + charakter.getUserId();
        String level = "|level: " + charakter.getLevel();
        String exp = "|exp: " + charakter.getExperience();
        String health = "|health: " + charakter.getHealth();
        String model = "|model id: " + charakter.getModelId();
        String race = "race id: " + charakter.getRaceId();
        String klassa = "class id: " + charakter.getClassId();
        String klassaName = "|class: " + charakter.getClassName();

        System.out.print(MainMenu.fillSpace(id, 15));
        System.out.print(MainMenu.fillSpace(name, 15));
        System.out.print(MainMenu.fillSpace(ownerId, 15));
        System.out.print(MainMenu.fillSpace(level, 15));
        System.out.print(MainMenu.fillSpace(exp, 15));
        System.out.print(MainMenu.fillSpace(health, 15));
        System.out.print(MainMenu.fillSpace(model, 15));
        System.out.print(MainMenu.fillSpace(race, 15));
        System.out.print(MainMenu.fillSpace(klassa, 15));
        System.out.print(MainMenu.fillSpace(klassaName, 15));
        System.out.println("|");
    }

}
