package root.ui;

import root.rdg.Klassa;

/**
 *
 * @author shanki
 */
public class KlassaPrinter {

    public static void print(Klassa klassa) {
        if (klassa == null)
            throw new NullPointerException("class cannot be null");

        String id = "|id: " + klassa.getId();
        String name = "|name: " + klassa.getName();
        String defaultHp = "|default hp: " + klassa.getDefaultHp();
        String defaultStr = "|default str: " + klassa.getDefaultStr();
        String defaultDef = "|default def: " + klassa.getDefaultDef();
        String hpMod = "|hp mod: " + klassa.getHpMod();
        String strMod = "|str mod: " + klassa.getStrMod();
        String defMod = "|def mod: " + klassa.getDefMod();

        System.out.print(MainMenu.fillSpace(id, 17));
        System.out.print(MainMenu.fillSpace(name, 17));
        System.out.print(MainMenu.fillSpace(defaultHp, 17));
        System.out.print(MainMenu.fillSpace(defaultStr, 17));
        System.out.print(MainMenu.fillSpace(defaultDef, 17));
        System.out.print(MainMenu.fillSpace(hpMod, 17));
        System.out.print(MainMenu.fillSpace(strMod, 17));
        System.out.print(MainMenu.fillSpace(defMod, 17));
        System.out.println("|");
    }
}
