package root.ui;

import root.rdg.Race;

/**
 *
 * @author luk
 */
public class RacePrinter {

    public static void print(Race race) {
        if (race == null)
            throw new NullPointerException("race cannot be null");

        String id = "|id: " + race.getId();
        String name = "|name: " + race.getName();
        String skinColor = "|skin: " + race.getSkinColor();
        String horns = "|horns: " + race.getHasHorns();
        String tail = "|tail: " + race.getHasTail();
        String lore = "|lore: " + race.getLore();

        System.out.print(MainMenu.fillSpace(id, 15));
        System.out.print(MainMenu.fillSpace(name, 15));
        System.out.print(MainMenu.fillSpace(skinColor, 15));
        System.out.print(MainMenu.fillSpace(horns, 15));
        System.out.print(MainMenu.fillSpace(tail, 15));
        System.out.print(MainMenu.fillSpace(lore, 90));
        System.out.println("|");
    }
}
