/****************************************************************************
*                example2.c
*
*
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "ft.h"

#ifdef BENCHMARK
#include <time.h>
#endif

/*****************************************************************************
* Local preprocessor defines
******************************************************************************/

/* #define DEBUG */
/* #define BENCHMARK */

/*****************************************************************************
* Local typedefs
******************************************************************************/

/*****************************************************************************
* Local variables
******************************************************************************/

/*****************************************************************************
* Static functions
******************************************************************************/

/*****************************************************************************
*
* FUNCTION
*
*   main
*
* INPUT
*
* OUTPUT
*
* RETURNS
*
* AUTHOR
*
*   Michelle Gavlak
*
* DESCRIPTION
*
*       2 processes, the first process ping[0] sends nr_messages messages to the 
*       second process pong[1], pong[1] returns the exact message back to ping[0].
*
* CHANGES
*
*   -
*
******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "ft.h"

#ifdef BENCHMARK
#include <time.h>
#endif

int main(int argc, char **argv) {
	static int nr_procs;
	static int proc_id;
	static int nr_messages;
	static int message_size;

	int i;

	#ifdef DEBUG
	int j;
	#endif

	#ifdef BENCHMARK
	struct timespec start, end;
	clock_gettime(CLOCK_REALTIME, &start);
	#endif

	char *data_to_send;
	char *msg;
	int msg_size;

	if (argc != 3) {
		fprintf(stderr, "Usage: %s <number of messages> <message size>\n", argv[0]);
		exit(1);
	}

	nr_procs = 2;
	nr_messages = atoi(argv[1]);
	message_size = atoi(argv[2]);

	ft_initialize(nr_procs, &proc_id);
	
	data_to_send = malloc(message_size);
	for (i = 0; i < message_size; i++) {
		data_to_send[i] = i;
	}

	for (i = 0; i < nr_messages; i++) {
		/*for each message i: ping[0] sends AND pong[1] receives && sends*/
		
		if (proc_id == 0) {	/*ping*/
			#ifdef DEBUG
			printf("PROGRAM INFO: Ping[0] sending a message to pong[1].\n");
			#endif
			
			ft_put(1, data_to_send, message_size);
				
			#ifdef DEBUG
			printf("POGRAM INFO: Ping[0] receives the message from pong[1].\n");
			#endif

			ft_get((void *) &msg, &msg_size);
			
			#ifdef DEBUG
            		for (j = 0; j < msg_size; j++)
                		printf("%d ", msg[j]);
            		printf("\n");
            		#endif

		} else {
			#ifdef DEBUG
                        printf("PROGRAM INFO: Pong[1] getting a message from ping[0].\n");
                        #endif

			ft_get((void *) &msg, &msg_size);

			#ifdef DEBUG
                        for (j = 0; j < msg_size; j++)
                                printf("%d ", msg[j]);
                        printf("\n");
                        #endif

			#ifdef DEBUG
                        printf("PROGRAM INFO: Pong[1] returning the message to ping[0].\n");
                        #endif

			ft_put(0, msg, msg_size);
		}
	}

	free(data_to_send);
	ft_deinitialize();

	#ifdef BENCHMARK
	clock_gettime(CLOCK_REALTIME, &end);
	printf("%d %ld\n", nr_messages, ((end.tv_sec*1000000)+(end.tv_nsec/1000)) - ((start.tv_sec*1000000)+(start.tv_nsec)/1000));
	#endif

	return 0;
}
