/****************************************************************************
*                program4.c
*
* 
*
*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include "ft.h"
#include "frame.h"

/*****************************************************************************
* Local preprocessor defines
******************************************************************************/

/* #define BENCHMARK */

/*****************************************************************************
* Local typedefs
******************************************************************************/

/*****************************************************************************
* Local variables
******************************************************************************/

static int nr_procs;
static int proc_id;
static int nr_messages;
static int message_size;
static pthread_mutex_t m;
static pthread_cond_t c;
static int collected;
static int sleeping;


/*****************************************************************************
* Static functions
******************************************************************************/

/*****************************************************************************
*
* FUNCTION
*
*   main
*
* INPUT
*
* OUTPUT
*
* RETURNS
*
* AUTHOR
*
*   Michelle Gavlak
*
* DESCRIPTION
*
*       N processes, each process sends nr_messages messages to each of the other
*       N-1 processes. Each following message is sent only after the process 
*       receives the previous message from all other N-1 processes. These are
*       received on a separate getter thread.
*       Each message starts with sender process id followed by the message itself.
*
* CHANGES
*
*   -
*
******************************************************************************/


static void *getter_thread_code(void *argument) {
	void *message;
	int size;
	int i, j;
	int num_mes, num_proc, mes_size;

	MUTEX_LOCK(&m);
	num_mes = nr_messages;
	num_proc = nr_procs;
	mes_size = message_size;
	MUTEX_UNLOCK(&m);

	#ifdef DEBUG
	int k;
	#endif
    
	for (j = 0; j < num_mes; j++) {
		for (i = 0; i < num_proc - 1; i++) {
             		ft_get(&message, &size);
					
			#ifdef DEBUG
                        printf("PROGRAM INFO: Process %d: received messages from %d processes: ", proc_id, i+1);
                        for (k = 0; k < mes_size; k++) {
                                printf("%hd ", ((char *) message)[k]);
                        }
                        printf("\n");
           		#endif

			FREE(message);
		}

		MUTEX_LOCK(&m);
		collected++;
		if (sleeping) {
        		COND_SIGNAL(&c);
		}
		MUTEX_UNLOCK(&m);
	}
	
	return NULL;
}

int main(int argc, char **argv) {
	int i, j;
	pthread_t thr;
        char *data_to_send;
	int num_mes, num_proc, mes_size;
	
	if (argc != 4) {
		ERROR("Usage: <number of processes> <number of messages> <message size>\n");
	}

	MUTEX_INIT(&m);
	COND_INIT(&c);

	nr_procs = atoi(argv[1]);
	nr_messages = atoi(argv[2]);
	message_size = atoi(argv[3]);

	collected = 0;
	sleeping = 0;

	#ifdef BENCHMARK
	double start = GET_TIME();
	#endif

	ft_initialize(nr_procs, &proc_id);

        MUTEX_LOCK(&m);
        num_mes = nr_messages;
        num_proc = nr_procs;
        mes_size = message_size;
        MUTEX_UNLOCK(&m);

	THR_CREATE(&thr, getter_thread_code);

	data_to_send = malloc(mes_size);
	for (i = 0; i < mes_size; i++) {
        	data_to_send[i] = i;
	}
	
	for (i = 0; i < num_mes; i++) {
		for (j = 0; j < num_proc; j++) {
                	if (proc_id != j) {
                        	#ifdef DEBUG
                        	printf("PROGRAM INFO: Process %d: putting message %d to process %d.\n", proc_id, i, j);
                        	#endif
				ft_put(j, data_to_send, mes_size);
			}
		}
		MUTEX_LOCK(&m);
        	while (!collected) {
			sleeping++;
			COND_WAIT(&c, &m);
			sleeping--;
		}
		collected--;
		MUTEX_UNLOCK(&m);
	}

	free(data_to_send);

	THR_JOIN(thr);
	COND_DESTROY(&c);
	MUTEX_DESTROY(&m);

	ft_deinitialize();

    	#ifdef BENCHMARK
    	double end = GET_TIME();
    	printf("%d %f\n", proc_id, TIME_DIFF(start, end));
    	#endif

	return 0;
}                        
