public class CreateToken {

    private StringBuilder content;       // aktuálny text tokenu
    private TokenType currentType;       // typ tokenu
    private TokenType lastType = null;     // typ predchádzajúceho tokenu

    public CreateToken() {
        this.content = new StringBuilder();
        this.currentType = null;
    }

    // Pridá znak, ak typ sedí – inak nič nerobí
    public boolean addChar(char c) {
        TokenType type = detectType(c);

        if (currentType == null) {
            currentType = type;
            content.append(c);
            lastType = type;
            return true;
        } else if (sameType(c)) {
            content.append(c);
            lastType = type;
            return true;
        } else {
            return false;
        }
    }

    // Skontroluje, či daný znak je rovnakého typu ako aktuálny
    public boolean sameType(char c) {
        return currentType == detectType(c);
    }

    // Vráti aktuálny token ako String
    public String getToken() {
        return content.toString();
    }

    // Vráti typ aktuálneho tokenu
    public TokenType getTokenType() {
        return currentType;
    }

    // Vyčistí token – pripravený na nový
    public void reset() {

        content.setLength(0);
        currentType = null;
    }

    // Pomocná metóda na detekciu typu znaku
    private TokenType detectType(char c) {
        if (Character.isLetter(c)) {
            return TokenType.WORD;
        } else if (Character.isWhitespace(c)) {
            return TokenType.SPACE;
        } else if (Character.isDigit(c)) {
            return TokenType.NUMBER;
        } else if (isInterpunkcia(c)) {
            if (c == '(' || c == ')' || c == '[' || c == ']' || c == '{' || c == '}') {
                return TokenType.BRACKETS;
            } else if (c == ',') {
                return TokenType.COMMA;
            } else if (c == ';') {
                return TokenType.SEMICOLON;
            } else if (c == '.') {
                return TokenType.DOT;
            } else if (c == '\'') {
                //System.out.println("ap*");
                return TokenType.APOSTROPH;
            } else if (c == '-') {
                return TokenType.DASH;
            } else if (c == ':'){
                return TokenType.COLON;
            } else if (c == '“' || c == '”' || c == '„') {
                return TokenType.QUOTATION_MARK;
            } else if (c == '…') {
                return TokenType.ELLIPSIS;
            } else if (c == '!') {
                return TokenType.EXCLAMATION_MARK;
            } else if (c == '?') {
                return TokenType.QUESTION_MARK;
            } else {
                return TokenType.OTHER;
            }
        } else {
            return TokenType.OTHER;
        }
    }

    // Pomocná metóda na kontrolu interpunkčných znakov
    private boolean isInterpunkcia(char c) {
        return ",.;:!?“”„…-()".indexOf(c) >= 0 || Character.toString(c).matches("\\p{Punct}");
    }
}