import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class Sentence implements Comparable<Sentence>{
    private List<String> content;
    private int count;
    private int interpunctionCount;
    private static final Set<String> PUNCTUATION = Set.of(".", ",", "!", "?", ";", ":");
    private int id;

    public Sentence(List<String> content, int id) {
        this.content = new ArrayList<>(content); // bezpečná kópia
        this.id = id;
        for (String token : content) {
            if (!PUNCTUATION.contains(token)) {
                count++;
            } else {
                interpunctionCount++;
            }
        }
    }

    // počet "slov" (nie interpunkcie)
    public int getWordCount() {
        return count;
    }
    public int getTotalCount() {
        return content.size();
    }
    // počet interpunkčných znamienok
    public int getPunctuationCount() {
        return interpunctionCount;
    }

    public int getId() {
        return id;
    }

    @Override
    public int compareTo(Sentence other) {
        // 1. viac slov hore
        int wordDiff = Integer.compare(other.getWordCount(), this.getWordCount());
        if (wordDiff != 0) return wordDiff;

        // 2. menej interpunkcie hore
        return Integer.compare(this.getPunctuationCount(), other.getPunctuationCount());
    }

    @Override
    public String toString() {
        return "[ " + String.join(" ", content) + " ]";
    }
}
