public class WordNeighborEdge {
    private String word;
    private String neighborWord;
    private int counter;

    public WordNeighborEdge(String word, String neighborWord) {
        this.word = word;
        this.neighborWord = neighborWord;
        this.counter = 1;
    }

    public String getWord() {
        return word;
    }

    public String getNeighborWord() {
        return neighborWord;
    }

    public int getCounter() {
        return counter;
    }

    public void setWord(String word) {
        this.word = word;
    }

    public void setNeighborWord(String neighborWord) {
        this.neighborWord = neighborWord;
    }

    // Porovnanie hrany bez ohľadu na poradie
    public boolean compareEdge(String from, String to) {
        return (word.equals(from) && neighborWord.equals(to)) ||
                (word.equals(to) && neighborWord.equals(from));
    }

    // Zvýši počet výskytov
    public void increaseCounter() {
        counter++;
    }

    @Override
    public String toString() {
        return "WNEdge[" + word + ", " + neighborWord + ", " + counter + "]";
    }
}