import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class test2 {
    static Map<String, Integer> wordCount = null;
    public static void main(String[] args) throws IOException {
        String path = "literatura/emr/naZapadeNicNove/DE";
        File file = new File(path + "/DE.pdf");
        Integer pageFrom = 9;
        List<String> ignoreWords = new ArrayList<>();
        ignoreWords.add("Erich Maria Remarque");
        ignoreWords.add("ALL QUIET ON THE WESTERN FRONT");
        GetRawTextFromPDF pdf = new GetRawTextFromPDF(file, 3, null, ignoreWords);
        String text = pdf.getText();
        TypeSplitter ts = new TypeSplitter(text, path);

        try (OutputStream os = new FileOutputStream(path + "/DE_tokenCount.txt")) {
            ts.printTokensCountSorted(os, 50);
        }
        try (OutputStream os = new FileOutputStream(path + "/DE_tokenCountWhite.txt")) {
            ts.printWhiteTokensCountSorted(os);
        }
        try (OutputStream os = new FileOutputStream(path + "/DE_tokenTypesCount.txt")) {
            ts.printTokenTypesCountSorted(os);
        }
        try (OutputStream os = new FileOutputStream(path + "/DE_tokenNeighbors.txt")) {
            ts.printNeighborCountSortedByValue(os);
        }
        try (OutputStream os = new FileOutputStream(path + "/DE_sentences.txt")) {
            ts.printSentenceStatistic(os);
        }
        //System.out.println(ts.getTokens());
        System.out.println(ts.getTokens().size());

    }

}