package cubes

import algorithmX.matrix.Matrix
import algorithmX.name.Name
import cubes.point.Point

class Shape(val name : String,
            points : Set<Point>) : Name, Puzzle(points) {

    companion object {

        //constants ------------------------------------------------
        private val EMPTY_NAME = ""

        //methods --------------------------------------------------
        fun emptyShape() : Shape {
            return Shape(EMPTY_NAME, hashSetOf())
        }

    }

    //methods -------------------------------------------------------
    override fun compareTo(other: Name): Int {
        return toString().compareTo(other.toString())
    }

    override fun toString() : String {
        return points.toSortedSet().toString()
    }

    override fun hashCode() : Int {
        return points.hashCode() + name.hashCode()
    }

    override fun equals(other : Any?) : Boolean {
        return other is Shape &&
                name == other.name &&
                points == other.points
    }

    override fun normalise() : Shape {
        val point = Point.instance.getMinimalCoordinates(points).invert()
        return translate(point)
    }

    override fun translate(offset : Point) : Shape {
        for (point in points) {
            point.add(offset)
        }
        return this
    }

    override fun rotate(matrix : Matrix) : Shape {
        for (point in points) {
            point.rotate(matrix)
        }
        size.rotate(matrix).absolute()
        return this
    }

    override fun copy() : Shape {
        val pointsCopy = mutableSetOf<Point>()
        for (point in points) {
            pointsCopy.add(point.copy())
        }
        return Shape(name, pointsCopy)
    }

    fun numberOfRotations() : Int {
        val rotationMatrices = Point.instance.rotations()
        val rotations = mutableSetOf<Shape>()
        for (rotationMatrix in rotationMatrices) {
            rotate(rotationMatrix)
            rotations.add(copy())
        }
        return rotations.size
    }

}