package games.geniusSquare.game

import algorithmX.printer.Printer

class GeniusSquareSpecifiedGame : GeniusSquareBase() {

    //constants ---------------------------------------------------------
    private val DEFAULT_INDEX = -1
    private val CHAR_INDEX = 0
    private val INT_INDEX = 1
    private val PAIR_LENGTH = 2
    private val CHAR = 0
    private val INT = 1
    private val DELIMETER = " "
    private val REPEATED_DICE = "Dice used more than once"
    private val WRONG_POSITION = "Not existing position"
    private val WRONG_DICES_COUNT = "Number of dices is not 7"
    private val WRING_DICE_FORMAT = "is not valid position"

    //methods -----------------------------------------------------------
    fun solveSpecifiedGame(indices : String,
                           printer : Printer,
                           allSolutions : Boolean,
                           printSolution : Boolean,
                           printResults : Boolean,
                           printDifficulty: Boolean) {
        generateGameAndSolveIt(
            DICES,
            specifiedIndices(indices),
            printer,
            allSolutions,
            printSolution,
            printResults,
            printDifficulty
        )
    }

    private fun specifiedIndices(indicesString: String) : List<Int> {
        val indices = mutableListOf<Int>()
        for (value in indicesString.split(DELIMETER)) {
            val trimmedValue = value.trim()
            if (trimmedValue.isBlank()) {
                continue
            }
            if (!(trimmedValue.length == PAIR_LENGTH &&
                        trimmedValue[CHAR].isLetter() &&
                        trimmedValue[INT].isDigit())) {
                throw IllegalArgumentException("$trimmedValue $WRING_DICE_FORMAT")
            }
            val pair = Pair(
                trimmedValue[CHAR_INDEX].toUpperCase(),
                trimmedValue[INT_INDEX].toString().toInt()
            )
            val index = findIndexPair(pair)
            extendListToSize(indices, index.first + 1)
            if (indices[index.first] != DEFAULT_INDEX) {
                throw IllegalArgumentException("${index.first + 1}. $REPEATED_DICE")
            }
            indices[index.first] = index.second
        }
        if (indices.size != DICES.size || indices.contains(DEFAULT_INDEX)) {
            throw IllegalArgumentException(WRONG_DICES_COUNT)
        }
        return indices
    }

    private fun findIndexPair(pair: Pair<Char, Int>) : Pair<Int, Int> {
        for ((index, dice) in DICES.withIndex()) {
            if (dice.contains(pair)) {
                return Pair(index, dice.indexOf(pair))
            }
        }
        throw IllegalArgumentException("$WRONG_POSITION ${pair.first}${pair.second}")
    }

    private fun extendListToSize(list: MutableList<Int>, size: Int) {
        while (list.size < size) {
            list.add(DEFAULT_INDEX)
        }
    }

}