package games.ubongo

import algorithmX.printer.NamePrinter
import algorithmX.printer.Printer
import cubes.Task
import cubes.point.Point3D
import cubes.Shape
import cubes.Puzzle
import games.ubongo.game.UbongoBase
import games.ubongo.game.UbongoGenerator

class Ubongo {

    companion object {

        //attributes ---------------------------------------------------------------------

        //monominoes ---------------------------

        /*
                X
        */
        val shape1I = Shape(
            "1I", setOf(
                Point3D(0, 0, 0)
            )
        )

        //dominoes -----------------------------

        /*
                XX
        */
        val shape2I = Shape(
            "2I", setOf(
                Point3D(0, 0, 0),
                Point3D(1, 0, 0)
            )
        )

        //trominoes ----------------------------

        /*
                XXX
        */
        val shape3I = Shape(
            "3I", setOf(
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(2, 0, 0)
            )
        )

        /*
                X
                XX
        */
        val shape3V = Shape(
            "3V", setOf(
                Point3D(0, 1, 0),
                Point3D(0, 0, 0),
                Point3D(1, 0, 0)
            )
        )

        //tetrominoes ---------------------------

        /*
                XXXX
        */
        val shape4I = Shape(
            "4I", setOf(
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(2, 0, 0),
                Point3D(3, 0, 0)
            )
        )

        /*
                X
                XXX
        */
        val shape4L = Shape(
            "4L", setOf(
                Point3D(0, 1, 0),
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(2, 0, 0)
            )
        )

        /*
                XXX
                 X
        */
        val shape4T = Shape(
            "4T", setOf(
                Point3D(1, 1, 0),
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(2, 0, 0)
            )
        )

        /*
                XX
                 XX
        */
        val shape4S = Shape(
            "4S", setOf(
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(1, 1, 0),
                Point3D(2, 1, 0)
            )
        )

        /*
                XX
                XX
        */
        val shape4O = Shape(
            "4O", setOf(
                Point3D(0, 1, 0),
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(1, 1, 0)
            )
        )

        /*
                o
                XX
        */
        val shape4V1 = Shape(
            "4V1", setOf(
                Point3D(0, 1, 0),
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(0, 1, 1)
            )
        )

        /*
                X
                Xo
        */
        val shape4V2 = Shape(
            "4V2", setOf(
                Point3D(0, 1, 0),
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(1, 0, 1)
            )
        )

        /*
                X
                oX
        */
        val shape4V3 = Shape(
            "4V3", setOf(
                Point3D(0, 1, 0),
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(0, 0, 1)
            )
        )

        //pentonimous ---------------------------

        /*
                XXXX
                   X
        */
        val shape5L = Shape(
            "5L", setOf(
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(2, 0, 0),
                Point3D(3, 0, 0),
                Point3D(3, 1, 0)
            )
        )

        /*
                XXX
                  X
                  X
        */
        val shape5V = Shape(
            "5V", setOf(
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(2, 0, 0),
                Point3D(2, 1, 0),
                Point3D(2, 2, 0)
            )
        )

        /*
                XXX
                  o
        */
        val shape5LV1 = Shape(
            "5LV1", setOf(
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(2, 0, 0),
                Point3D(2, 1, 0),
                Point3D(2, 1, -1)
            )
        )

        /*
                XXX
                o
        */
        val shape5LV2 = Shape(
            "5LV2", setOf(
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(2, 0, 0),
                Point3D(0, 1, 0),
                Point3D(0, 1, -1)
            )
        )

        /*
               o
               XX
                X
       */
        val shape5W1 = Shape(
            "5W1", setOf(
                Point3D(0, 0, 0),
                Point3D(0, 1, 0),
                Point3D(1, 1, 0),
                Point3D(1, 2, 0),
                Point3D(0, 0, 1)
            )
        )

        /*
               XXXX
                 X
       */
        val shape5Y = Shape(
            "5Y", setOf(
                Point3D(0, 0, 0),
                Point3D(1, 0, 0),
                Point3D(2, 0, 0),
                Point3D(3, 0, 0),
                Point3D(2, 1, 0)
            )
        )

        //methods ------------------------------------------------------------
        fun solveSpecifiedGame(
            puzzle: Puzzle,
            shapes: Set<Shape> = setOf(),
            printer: Printer = NamePrinter(),
            allSolutions: Boolean = true,
            printSolution: Boolean = true,
            printResult: Boolean = true,
            printDifficulty: Boolean = true
        ) {
            val task = Task(
                puzzle,
                shapes
            )
            UbongoBase().solveSpecifiedGame(
                task,
                printer,
                allSolutions,
                printSolution,
                printResult,
                printDifficulty
            )
        }

        fun solveSpecifiedGameWithRepetitions(
            puzzle: Puzzle,
            shapes: Set<Shape> = setOf(),
            printer: Printer = NamePrinter(),
            allSolutions: Boolean = true,
            printSolution: Boolean = true,
            printResult: Boolean = true,
            printDifficulty: Boolean = true
        ) {
            val task = Task(
                puzzle,
                repeatableShapes = shapes
            )
            UbongoBase().solveSpecifiedGame(
                task,
                printer,
                allSolutions,
                printSolution,
                printResult,
                printDifficulty
            )
        }

        fun solveGeneratedGame(printer: Printer = NamePrinter(),
                               hardnessLevel: Int = 1,
                               allSolutions: Boolean = true,
                               printSolution: Boolean = true,
                               printResult: Boolean = true,
                               printDifficulty: Boolean = true) {
            UbongoGenerator().generateAndSolveGame(
                printer,
                hardnessLevel,
                allSolutions,
                printSolution,
                printResult,
                printDifficulty
            )
        }

    }

}