package games.ubongo.game

import algorithmX.AlgorithmX
import algorithmX.printer.Printer
import cubes.Task
import cubes.Formalisation
import cubes.Difficulty

class UbongoBase {

    //constants ------------------------------------------------------------------------------
    private val PRECISION = 20
    private val RESULT_STRING = "Number of solutions:"
    private val DIFFICULTY_STRING = "difficulty:"

    //methods --------------------------------------------------------------------------------
    fun solveSpecifiedGame(task: Task,
                           printer: Printer,
                           allSolutions : Boolean,
                           printSolution : Boolean,
                           printResult : Boolean,
                           printDifficulty: Boolean) {
        task.puzzle.normalise()
        val pair = Formalisation().createMatrixAndNamesFromTask(task, true)
        printer.reset()
        val numberOfSolutions = AlgorithmX(
            pair.first,
            pair.second,
            printer,
            allSolutions
        ).solve()
        if (printResult) {
            printResult(numberOfSolutions)
        }
        if (printDifficulty) {
            val difficulty = Difficulty().calculateDifficulty(task)
            printDifficulty(difficulty)
        }
        if (printSolution) {
            printer.print()
        }
    }

    private fun printResult(numberOfSolutions : Int) {
        println("$RESULT_STRING $numberOfSolutions")
    }

    private fun printDifficulty(difficulty : Double) {
        println("$DIFFICULTY_STRING %.${PRECISION}f".format(difficulty))
    }

}