package tests

import cubes.Puzzle
import cubes.point.*
import games.ubongo.Ubongo
import games.ubongo.printer.*
import java.lang.IllegalArgumentException

class TestUbongo {

    companion object {

        fun testAll() {
            testSpecifiedGames()
            testGeneratedGames()
        }

        fun testSpecifiedGames() {
            val printer = GLUbongoPrinter()
            var puzzle = Puzzle(
                setOf(
                    Point3D(0),
                    Point3D(1)
                )
            )
            var shapes = setOf(
                Ubongo.shape1I
            )
            Ubongo.solveSpecifiedGame(puzzle, shapes, printer = printer)

            puzzle = Puzzle(
                setOf(
                    Point3D(0)
                )
            )
            shapes = setOf(
                Ubongo.shape1I
            )
            Ubongo.solveSpecifiedGame(puzzle, shapes, printer = printer)

            puzzle = Ubongo.shape4L.copy()
            shapes = setOf(
                Ubongo.shape4L
            )
            Ubongo.solveSpecifiedGame(puzzle, shapes, printer = printer)

            puzzle = Ubongo.shape4V1.copy()
            shapes = setOf(
                Ubongo.shape4V1
            )
            Ubongo.solveSpecifiedGame(puzzle, shapes, printer = printer)

            puzzle = Puzzle(
                setOf(
                    Point3D(0),
                    Point3D(1),
                    Point3D(2),
                    Point3D(3)
                )
            )
            shapes = setOf(
                Ubongo.shape1I,
                Ubongo.shape3I
            )
            Ubongo.solveSpecifiedGame(puzzle, shapes, printer = printer)


            puzzle = Puzzle(
                setOf(
                    Point3D(0),
                    Point3D(1),
                    Point3D(2),
                    Point3D(3),
                    Point3D(4),
                    Point3D(5)
                )
            )
            shapes = setOf(
                Ubongo.shape1I,
                Ubongo.shape2I,
                Ubongo.shape3I
            )
            Ubongo.solveSpecifiedGame(puzzle, shapes, printer = printer)


            puzzle = Puzzle(
                setOf(
                    Point3D(0, 0),
                    Point3D(1, 0),
                    Point3D(2, 0),
                    Point3D(0, 1),
                    Point3D(1, 1),
                    Point3D(2, 1)
                )
            )
            shapes = setOf(
                Ubongo.shape1I,
                Ubongo.shape2I,
                Ubongo.shape3V
            )
            Ubongo.solveSpecifiedGame(puzzle, shapes, printer = printer)


            puzzle = Puzzle(
                setOf(
                    Point3D(0),
                    Point3D(1),
                    Point3D(2),
                    Point3D(3),
                    Point3D(0, 1),
                    Point3D(3, 1)
                )
            )
            shapes = setOf(
                Ubongo.shape1I,
                Ubongo.shape2I,
                Ubongo.shape3I
            )
            Ubongo.solveSpecifiedGame(puzzle, shapes, printer = printer)


            puzzle = Puzzle(
                setOf(
                    Point3D(0),
                    Point3D(1),
                    Point3D(2),
                    Point3D(3),
                    Point3D(0, 1),
                    Point3D(3, 1),
                    Point3D(0, 2),
                    Point3D(1, 2),
                    Point3D(2, 2),
                    Point3D(3, 2)
                )
            )
            shapes = setOf(
                Ubongo.shape1I,
                Ubongo.shape2I,
                Ubongo.shape3I,
                Ubongo.shape4I
            )
            Ubongo.solveSpecifiedGame(puzzle, shapes, printer = printer)


            puzzle = Puzzle(
                setOf(
                    Point3D(0),
                    Point3D(1),
                    Point3D(2),
                    Point3D(3),
                    Point3D(0, 1),
                    Point3D(3, 1),
                    Point3D(3, -1),
                    Point3D(3, -2),
                    Point3D(3, -3),
                    Point3D(3, -4)
                )
            )
            shapes = setOf(
                Ubongo.shape1I,
                Ubongo.shape2I,
                Ubongo.shape3I,
                Ubongo.shape4I
            )
            Ubongo.solveSpecifiedGame(puzzle, shapes, printer = printer)


            puzzle = Puzzle(
                setOf(
                    Point3D(0, 0, 0),
                    Point3D(1, 0, 0),
                    Point3D(2, 0, 0),
                    Point3D(0, 0, 1),
                    Point3D(1, 0, 1),
                    Point3D(2, 0, 1),
                    Point3D(0, 1, 0),
                    Point3D(1, 1, 0),
                    Point3D(2, 1, 0)
                )
            )
            shapes = setOf(
                Ubongo.shape1I,
                Ubongo.shape2I,
                Ubongo.shape3V,
                Ubongo.shape3I
            )
            Ubongo.solveSpecifiedGame(puzzle, shapes, printer = printer)


            puzzle = Puzzle(
                setOf(
                    Point3D(1, 0, 0),
                    Point3D(2, 0, 0),
                    Point3D(3, 0, 0),
                    Point3D(0, 1, 0),
                    Point3D(1, 1, 0),
                    Point3D(2, 1, 0),
                    Point3D(3, 1, 0),
                    Point3D(3, 2, 0),
                    Point3D(1, 0, 1),
                    Point3D(2, 0, 1),
                    Point3D(3, 0, 1),
                    Point3D(0, 1, 1),
                    Point3D(1, 1, 1),
                    Point3D(2, 1, 1),
                    Point3D(3, 1, 1),
                    Point3D(3, 2, 1)
                )
            )
            shapes = setOf(
                Ubongo.shape3V,
                Ubongo.shape4V1,
                Ubongo.shape4V2,
                Ubongo.shape5LV1
            )
            Ubongo.solveSpecifiedGame(puzzle, shapes, printer = printer)


            puzzle = Puzzle(
                setOf(
                    Point3D(0, 0, 0),
                    Point3D(1, 0, 0),
                    Point3D(2, 0, 0),
                    Point3D(3, 0, 0),
                    Point3D(1, -1, 0),
                    Point3D(1, 1, 0),
                    Point3D(3, -1, 0),
                    Point3D(0, 0, 1),
                    Point3D(1, 0, 1),
                    Point3D(2, 0, 1),
                    Point3D(3, 0, 1),
                    Point3D(1, -1, 1),
                    Point3D(1, 1, 1),
                    Point3D(3, -1, 1)
                )
            )
            shapes = setOf(
                Ubongo.shape3V,
                Ubongo.shape2I,
                Ubongo.shape4L,
                Ubongo.shape5W1
            )
            Ubongo.solveSpecifiedGame(puzzle, shapes, printer = printer)
        }

        fun testGeneratedGames() {
            val printer = GLUbongoPrinter()
            Ubongo.solveGeneratedGame(printer, 1)
            Ubongo.solveGeneratedGame(printer, 2)
            Ubongo.solveGeneratedGame(printer, 3)
            Ubongo.solveGeneratedGame(printer, 4)
            try {
                Ubongo.solveGeneratedGame(printer, 5)
            } catch (exception: IllegalArgumentException) {
                println(exception.message)
            }
            try {
                Ubongo.solveGeneratedGame(printer, 0)
            } catch (exception: IllegalArgumentException) {
                println(exception.message)
            }
        }

    }

}