//
// Created by erikk on 5/20/2021.
//

#include <vector>
#include <fstream>
#include <DLX.hpp>
#include "Benchmark.hpp"
#include <chrono>
#include <iostream>

using namespace std;
using namespace std::chrono;

void Benchmark::readExactCoverProblemsFromFile() {
    ifstream file = ifstream(FILE);
    if (file.fail()) {
        return;
    }
    string line;
    auto *matrix = new vector<vector<int>>;
    while (true) {
        getline(file, line);
        if (line == "") {
            if (matrix->empty()) {
                break;
            }
            counter++;
            auto timeBegin = system_clock::now();
            auto dlx = new DLX(*matrix);
            dlx->solve();
            auto timeEnd = system_clock::now();
            duration<double> difference = timeEnd - timeBegin;
            cout << counter << ". time = " << (int) (difference.count() * 1000) << "\n";
            matrix->clear();
        } else {
            long unsigned int position;
            auto *matrixLine = new vector<int>;
            while ((position = line.find(DELIMETER)) != string::npos) {
                matrixLine->push_back(stoi(line.substr(0, position)));
                line.erase(0, position + DELIMETER.length());
            }
            matrix->push_back(*matrixLine);
        }
    }
    file.close();
}