package algorithmX

import algorithmX.matrix.Matrix
import java.io.File

class Benchmark {

    companion object {

        //attributes ---------------------------------------------------------------
        private var counter = 0

        //constants ----------------------------------------------------------------
        val FILE = "matrices.txt"

        //methods ------------------------------------------------------------------
        fun deleteWriteFile() {
            val file = File(FILE)
            if (file.exists()) {
                file.delete()
            }
        }

        fun readExactCoverProblemsFromFile() {
            if (!File(FILE).exists()) {
                return
            }
            val reader = File(FILE).inputStream().bufferedReader()
            while (true) {
                val matrix = mutableListOf<List<Int>>()
                var line: String? = reader.readLine() ?: return
                while (line!!.isNotEmpty()) {
                    matrix.add(line.split(" ").map { it.toInt() })
                    line = reader.readLine()
                }
                val timeBegin = System.currentTimeMillis()
                AlgorithmX(Matrix(matrix), printSolutions = false).solve()
                val timeEnd = System.currentTimeMillis()
                counter++
                println("${counter}. time = ${timeEnd - timeBegin}")
            }
        }

    }

}

fun main() {
    Benchmark.readExactCoverProblemsFromFile()
}