package algorithmX.matrix

class Matrix(var matrix : List<List<Int>> = listOf()) {

    override fun toString(): String {
        var matrixString = ""
        for (vector in matrix) {
            var vectorString = ""
            for (scalar in vector) {
                vectorString += "$scalar "
            }
            matrixString += "{ $vectorString}\n"
        }
        return matrixString
    }

    fun multiply(other : Matrix) : Matrix {
        if (matrix[0].size != other.matrix.size) {
            return Matrix()
        }
        val output = MutableList(matrix.size) { MutableList(other.matrix[0].size) { 0 } }
        for (i in matrix.indices) {
            for (j in other.matrix[0].indices) {
                for (k in matrix[0].indices) {
                    output[i][j] += matrix[i][k] * other.matrix[k][j]
                }
            }
        }
        return Matrix(output)
    }

}