package cubes

import algorithmX.AlgorithmX
import algorithmX.name.Name
import algorithmX.printer.NamePrinter
import cubes.point.*

class Difficulty {

    //attributes -----------------------------------------------------------
    private val frequency = mutableMapOf<String, MutableSet<Shape>>()

    //constants ------------------------------------------------------------
    private val PRINTER = NamePrinter()
    private val ALL_SOLUTIONS = true
    private val IMPOSSIBLE = 0.0
    private val DEFUALT_DIFFICULTY = 1.0
    private var writeToFile = false

    //methods --------------------------------------------------------------
    fun calculateDifficulty(task: Task) : Double {
        blockWriteToFile()
        val numberOfSolutions = solve(task)
        if (numberOfSolutions == 0) {
            releaseWriteToFile()
            return IMPOSSIBLE
        }
        searchSolutionForShapeFrequency()
        val baseDifficulty = calculateBaseDifficulty(task)
        releaseWriteToFile()
        return baseDifficulty / numberOfSolutions.toDouble()
    }

    private fun blockWriteToFile() {
        writeToFile = Formalisation.writeToFile
        Formalisation.writeToFile = false
    }

    private fun solve(task: Task) : Int{
        val formalisation = Formalisation()
        val pair = formalisation.createMatrixAndNamesFromTask(task, false)
        PRINTER.reset()
        return AlgorithmX(
            pair.first,
            pair.second,
            PRINTER,
            ALL_SOLUTIONS
        ).solve()
    }

    private fun searchSolutionForShapeFrequency() {
        val solutions = PRINTER.solutions
        for (solution in solutions) {
            for (row in solution) {
                val shape = toShape(row)
                if (!frequency.containsKey(shape.name)) {
                    frequency[shape.name] = mutableSetOf()
                }
                frequency[shape.name]!!.add(shape)
            }
        }
    }

    private fun toShape(names: List<Name>) : Shape {
        val points = mutableSetOf<Point>()
        var shapeName = names.toString()
        for (name in names) {
            if (name is Point) {
                points.add(name.copy())
            } else if (name is Shape) {
                shapeName = name.name
            }
        }
        return Shape(shapeName, points)
    }

    private fun calculateBaseDifficulty(task: Task) : Double {
        var difficulty = DEFUALT_DIFFICULTY
        for (shape in task.shapes) {
            if (shape.points.size == 1) {
                continue
            }
            val tempTask = Task(task.puzzle, shapes = setOf(shape))
            val matrix = Formalisation().createMatrixAndNamesFromTask(tempTask, false).first
            val quotient = frequency[shape.name]!!.size.toDouble() / matrix.matrix.size.toDouble()
            difficulty *= quotient
        }
        return difficulty
    }

    private fun releaseWriteToFile() {
        Formalisation.writeToFile = writeToFile
    }

}