package cubes

import algorithmX.matrix.Matrix
import cubes.point.Point

open class Puzzle(val points : Set<Point>) {

    //attributes --------------------------------------------------------------
    lateinit var size : Point

    //constructors ------------------------------------------------------------
    init {
        setDimensions()
    }

    //methods -----------------------------------------------------------------
    private fun setDimensions() {
        val minCoordinates = Point.instance.getMinimalCoordinates(points)
        val maxCoordinates = Point.instance.getMaximalCoordinates(points)
        size = maxCoordinates.subtract(minCoordinates).add(Point.instance.one())
    }

    override fun hashCode() : Int {
        return points.hashCode()
    }

    override fun equals(other : Any?) : Boolean {
        return other is Puzzle &&
                points == other.points
    }

    open fun normalise() : Puzzle {
        val point = Point.instance.getMinimalCoordinates(points).invert()
        return translate(point)
    }

    open fun translate(offset : Point) : Puzzle {
        for (point in points) {
            point.add(offset)
        }
        return this
    }

    open fun rotate(matrix : Matrix) : Puzzle {
        for (point in points) {
            point.rotate(matrix)
        }
        size.rotate(matrix).absolute()
        return this
    }

    open fun copy() : Puzzle {
        val pointsCopy = mutableSetOf<Point>()
        for (point in points) {
            pointsCopy.add(point.copy())
        }
        return Puzzle(pointsCopy)
    }

}