package cubes.point

import algorithmX.name.Name
import algorithmX.matrix.Matrix

interface Point : Name {

    //attributes ------------------------------------------------------------------
    companion object{

        lateinit var instance : Point

    }

    //methods ---------------------------------------------------------------------
    fun cos(angle : Int) : Int {
        return kotlin.math.cos(degreeToRadian(angle)).toInt()
    }

    fun sin(angle : Int) : Int {
        return kotlin.math.sin(degreeToRadian(angle)).toInt()
    }

    private fun degreeToRadian(angle : Int) : Double {
        return angle * Math.PI / 180
    }

    override fun toString() : String

    override fun equals(other : Any?) : Boolean

    override fun hashCode() : Int

    fun copy() : Point

    fun one() : Point

    fun left() : Point

    fun right() : Point

    fun top() : Point

    fun bottom() : Point

    fun front() : Point

    fun set(other: Point) : Point

    fun add(other : Point) : Point

    fun subtract(other : Point) : Point

    fun multiply(other: Point) : Point

    fun divide(other: Point) : Point

    fun invert() : Point

    fun absolute() : Point

    fun rotate(matrix: Matrix) : Point

    fun isLessOrEqual(other: Point) : Boolean

    fun getMinimalCoordinates(points : Set<Point>) : Point

    fun getMaximalCoordinates(points : Set<Point>) : Point

    fun rotations() : List<Matrix>
    
}