package games

import kotlin.math.abs

class Colour(val r : Double = 0.0,
             val g : Double = 0.0,
             val b : Double = 0.0) {

    //constants ----------------------------------------------------------------------
    companion object {

        val COLOURS = mutableListOf(
            Colour(1.0, 0.0, 0.0),
            Colour(0.0, 1.0, 0.0),
            Colour(0.0, 0.0, 1.0),
            Colour(1.0, 1.0, 0.0),
            Colour(1.0, 0.0, 1.0),
            Colour(0.0, 1.0, 1.0),

            Colour(0.9458814093911453, 0.68006189053087818, 0.0072192681004556),
            Colour(0.12467787282088256, 0.6289598010585171, 0.25667850710605977),
            Colour(0.4591119660967975, 0.15381031631914954, 0.69370477065319),
            Colour(0.6950755715224447, 0.5274969030589824, 0.011227536856045939),
            Colour(0.07077585804715947, 0.4855158473419776, 0.9156219360324542),
            Colour(0.22226140517418458, 0.9572119110376729, 0.6791988575032321),

            Colour(0.8034381615388745, 0.3448264531903157, 0.2484930163075727),
            Colour(0.8183533910504348, 0.6362231591622203, 0.4322197560489135),
            Colour(0.6677422568704885, 0.20990115330199388, 0.6599005122685919),
            Colour(0.5671288504676171, 0.16572224180511108, 0.3109748993371797),
            Colour(0.24362244548430612, 0.5697881187006747, 0.42480536965711424),
            Colour(0.46242220460389816, 0.16239384795252043, 0.39361039295696365),

            Colour(0.6217344067347294, 0.800704752930314, 0.010880188648713762),
            Colour(0.9278983032159768, 0.8308175749020586, 0.3845222058749421),
            Colour(0.2733141155362592, 0.22677513975789043, 0.057149918153098334),
            Colour(0.6312397789972353, 0.6450329399584067, 0.730647772124568),
            Colour(0.07981890292481819, 0.4410883827386377, 0.35660475842745243),
            Colour(0.9644259810250421, 0.3441653406948856, 0.12467970906737669),

            Colour(0.9846491823603415, 0.4999857305599241, 0.7368983986581873),
            Colour(0.23352815865630372, 0.3215049404024013, 0.07073458365856411),
            Colour(0.5682705368365533, 0.7218317654852491, 0.9501169920471946),
            Colour(0.7961904697607654, 0.9126853078211247, 0.6209407360603946),
            Colour(0.4098107249355487, 0.2300650860861836, 0.007182453356654683),
            Colour(0.8441307539306429, 0.18044338772288215, 0.5633610143218827)
        )

    }
    private val GRANULITY = 0.005

    //constructors -------------------------------------------------------------------
    constructor(r : Float,
                g : Float,
                b : Float) :
            this(r.toDouble(),
                g.toDouble(),
                b.toDouble())

    //methods ------------------------------------------------------------------------
    override fun toString(): String {
        return "($r, $g, $b)"
    }

    override fun equals(other: Any?): Boolean {
        return other is Colour &&
                abs(r - other.r) < GRANULITY &&
                abs(g - other.g) < GRANULITY &&
                abs(b - other.b) < GRANULITY
    }

}