package games.geniusSquare

import algorithmX.printer.NamePrinter
import algorithmX.printer.Printer
import games.geniusSquare.game.GeniusSquareAllGames
import games.geniusSquare.game.GeniusSquareCreateGames
import games.geniusSquare.game.GeniusSquareRandomGame
import games.geniusSquare.game.GeniusSquareSpecifiedGame

class GeniusSquare {

    //methods -------------------------------------------------------------------------
    companion object {

        fun solveRandomGame(printer: Printer = NamePrinter(),
                            allSolutions : Boolean = true,
                            printSolution : Boolean = true,
                            printResults : Boolean = true,
                            printDifficulty: Boolean = true) {
            GeniusSquareRandomGame().solveRandomGame(
                printer,
                allSolutions,
                printSolution,
                printResults,
                printDifficulty
            )
        }

        fun solveSpecifiedGame(indices: String,
                               printer: Printer = NamePrinter(),
                               allSolutions : Boolean = true,
                               printSolution : Boolean = true,
                               printResults : Boolean = true,
                               printDifficulty: Boolean = true) {
            GeniusSquareSpecifiedGame().solveSpecifiedGame(
                indices,
                printer,
                allSolutions,
                printSolution,
                printResults,
                printDifficulty
            )
        }

        fun solveAllGames(printer: Printer = NamePrinter(),
                          allSolutions : Boolean = true,
                          printSolution : Boolean = true,
                          printResults : Boolean = true) {
            GeniusSquareAllGames().solveAllGames(
                printer,
                allSolutions,
                printSolution,
                printResults
            )
        }

        fun solveAllGamesWithSpecifiedDices(dices: List<List<Pair<Char, Int>>>,
                                            printer: Printer = NamePrinter(),
                                            allSolutions : Boolean = true,
                                            printSolution : Boolean = true,
                                            printResults : Boolean = true) {
            GeniusSquareAllGames().solveAllGamesWithSpecifiedDices(
                dices,
                printer,
                allSolutions,
                printSolution,
                printResults
            )
        }

        fun createNewGames() {
            GeniusSquareCreateGames().createNewGames()
        }

    }

}